% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_Shuttleworth_Wallace.R
\name{cal_sensibleHeatFluxesForSoil}
\alias{cal_sensibleHeatFluxesForSoil}
\title{Calaulating sensible heat fluxes for soil}
\usage{
cal_sensibleHeatFluxesForSoil(
  gamma = 0.659,
  As,
  r_s_s,
  r_s_a,
  rho_cp,
  D0,
  DELTA
)
}
\arguments{
\item{gamma}{is the psychometric constant (0.658 mbar K-1)}

\item{As}{energy available to the soil (W m-2 ground)}

\item{r_s_s}{soil surface resistance,  (s m-1)}

\item{r_s_a}{is the aerodynamic resistance between the soil and mean anopy flow (s m-1);}

\item{rho_cp}{the volumetric heat capacity for air (1221.09 J m-3 K-1)}

\item{D0}{the vapor pressure deficit at the mean canopy flow}

\item{DELTA}{the slope of the saturated vapor pressure curve (mbar K-1)}
}
\value{
A vector for soil sensible heat fluxes(W m-2 ground)
}
\description{
Calaulating sensible heat fluxes for soil
}
