% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_normal_model.R
\name{log_normal_model}
\alias{log_normal_model}
\title{Defines a log normal model for peak height variability}
\usage{
log_normal_model(
  template,
  degradation = rep(0, length(template)),
  LSAE = stats::setNames(rep(1, length(model_settings$locus_names)),
    model_settings$locus_names),
  c2,
  k2,
  model_settings
)
}
\arguments{
\item{template}{Numeric vector}

\item{degradation}{Numeric vector of same length as template. Degradation parameters for each contributor.}

\item{LSAE}{Numeric vector (named) with Locus Specific Amplification Efficiencies. See \link{sample_LSAE}. Defaults to 1 for each locus.}

\item{c2}{Numeric. Allele variance parameter.}

\item{k2}{Optionally a numeric vector with stutter variance parameters. See \link{sample_log_normal_stutter_variance}.}

\item{model_settings}{List. Possible parameters: \itemize{
\item locus_names. Character vector.
\item degradation_parameter_cap. Numeric.
\item c2_prior. Numeric of length two with shape and scale.
\item LSAE_variance_prior. Numeric of length one.
\item detection_threshold. Numeric vector (named) with Detection Thresholds. Defaults to 50 for each locus.
\item size_regression. Function, see \link{read_size_regression}.
\item stutter_model. Optionally a stutter_model object that gives expected stutter heights. See \link{global_stutter_model}.
\item stutter_variability. Optionally peak height variability parameters for stutters. Required when stutter_model is supplied.
}}
}
\value{
Object of class \code{pg_model}.
}
\description{
Defines a log normal model for peak height variability
}
\details{
Define a log normal model for peak height variability with the parametrisation as described by Bright et al. The model may then be used to sample DNA profiles using the \link{sample_mixture_from_genotypes} function. Alternatively, to sample many models and profiles in one go with parameters according to a specified distribution, the \link{sample_mixtures} function can be used.
}
\examples{
gf <- gf_configuration()
freqs <- read_allele_freqs(system.file("extdata","FBI_extended_Cauc_022024.csv",
                           package = "simDNAmixtures"))

k2 <- sample_log_normal_stutter_variance(gf$log_normal_settings$stutter_variability)

model <- log_normal_model(template = 1e3, c2 = 15, k2 = k2,
                          model_settings = gf$log_normal_settings)
model
}
\references{
Bright, J.A. et al. (2016). Developmental validation of STRmix™, expert software for the interpretation of forensic DNA profiles. Forensic Science International: Genetics, 23, 226-239. \doi{10.1016/j.fsigen.2016.05.007}
}
\seealso{
\link{gamma_model}.
}
