% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/siie.R
\name{siie}
\alias{siie}
\title{Calculation of SII and SIE}
\usage{
siie(df, group, index, p = 10)
}
\arguments{
\item{df}{A data.frame containing at least two columns (namely the group and the
index of each individual).}

\item{group}{The group avariable. In the context of our paper,
this could be the name or ISSN of a journal.}

\item{index}{The indicator of individuals. In the context of our paper,
this could be citation index of papers.}

\item{p}{Cutoff of superior. Defaults to 10, meaning top 10 percent individuals are
regarded as superior.}
}
\value{
A data.table with 5 columns, with the group, superior number (superior_no),
  total number in the group (total_no), SII (sii) and SIE (sie).
}
\description{
Calculate SII (Superior Identification Index) and
  SIE (Superior Identification Efficiency) for each group with individual values.
  In the context of the paper, we have citation counts of papers from different journals.
  This function could calculate SII and SIE for each journal within the field.
}
\details{
In the context, SII indicates how well a journal could identify the
  top papers (superior research), whereas SIE quantifies the efficiency of
  a journal to identify the top papers.
}
\examples{

set.seed(19960822)
nr_of_rows = 1e4
data.frame(
  Id = 1:1e4,
  Journal = sample(LETTERS,nr_of_rows,replace = TRUE),
  CiteCount = sample(1:100,nr_of_rows,replace = TRUE)
) -> journal_table
siie(journal_table,group = "Journal",index = "CiteCount")

}
\references{
Huang, TY., Yang, L. Superior identification index: Quantifying the capability of academic journals to recognize good research. Scientometrics 127, 4023–4043 (2022). https://doi.org/10.1007/s11192-022-04372-z
}
