% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/store_layers.R
\name{store_layers}
\alias{store_layers}
\title{Write GeoPackage Layers with Geometry to PostGIS}
\usage{
store_layers(
  gpkg,
  conn,
  schema = "public",
  prefix = NULL,
  postfix = NULL,
  layers = NULL,
  geom_colum = "geom",
  snake_case_fields = TRUE
)
}
\arguments{
\item{gpkg}{A string, the path to the GeoPackage file.}

\item{conn}{A PostGIS database connection object created with [RPostgres::dbConnect()].}

\item{schema}{A string, the schema in PostGIS where layers will be stored. Default is `"public"`.}

\item{prefix}{A string, an optional prefix to add to the table names in PostGIS. Default is `NULL`.}

\item{postfix}{A string, an optional postfix to add to the table names in PostGIS. Default is `NULL`.}

\item{layers}{A string vector, the name of the layers to transfer. If NULL,
all vector layers are transferred.}

\item{geom_colum}{A string, the name of the geometry column to set. Default is `"geom"`.}

\item{snake_case_fields}{A logical, whether to convert field names to Snake Case. Default is `TRUE`.}
}
\value{
Invisibly returns a character vector of the names of the tables written to PostGIS.
}
\description{
Transfers vector layers with valid geometries from a GeoPackage file
to a specified PostGIS database schema. Optionally allows setting a custom
geometry column name, adding prefixes or postfixes to the table names, and
renaming the layer fields to follow the Snake Case convention.
}
\examples{
\dontrun{
source_gpkg <- system.file("extdata", "sigugr.gpkg", package = "sigugr")

conn <- DBI::dbConnect(
  RPostgres::Postgres(),
  dbname = "mydb",
  host = "localhost",
  user = "user",
  password = "password"
)

store_layers(
  source_gpkg, conn, prefix = "pre_", postfix = "_post"
)

DBI::dbDisconnect(conn)
}

}
\seealso{
Other write to PostGIS: 
\code{\link{store_bands}()},
\code{\link{store_raster}()}
}
\concept{write to PostGIS}
