% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_cn_circos.R
\name{show_cn_circos}
\alias{show_cn_circos}
\title{Show Copy Number Profile in Circos}
\usage{
show_cn_circos(
  data,
  samples = NULL,
  show_title = TRUE,
  chrs = paste0("chr", 1:22),
  genome_build = c("hg19", "hg38", "T2T", "mm10", "mm9", "ce11"),
  col = NULL,
  side = "inside",
  ...
)
}
\arguments{
\item{data}{a \link{CopyNumber} object or a \code{data.frame} containing at least 'chromosome', 'start',
'end', 'segVal' these columns.}

\item{samples}{default is \code{NULL}, can be a chracter vector representing multiple samples or
number of samples to show.
If data argument is a \code{data.frame}, a column called sample must exist.}

\item{show_title}{if \code{TRUE} (default), show title with sample ID.}

\item{chrs}{chromosomes start with 'chr'.}

\item{genome_build}{genome build version, used when \code{data} is a \code{data.frame}, should be 'hg19' or 'hg38'.}

\item{col}{colors for the heatmaps. If it is \code{NULL}, set to
\code{circlize::colorRamp2(c(1, 2, 4), c("blue", "black", "red"))}.}

\item{side}{side of the heatmaps.}

\item{...}{other parameters passing to \link[circlize:circos.genomicHeatmap]{circlize::circos.genomicHeatmap}.}
}
\value{
a circos plot
}
\description{
Another visualization method for copy number profile like \link{show_cn_profile}.
}
\examples{
load(system.file("extdata", "toy_copynumber.RData",
  package = "sigminer", mustWork = TRUE
))
\donttest{
show_cn_circos(cn, samples = 1)
show_cn_circos(cn, samples = "TCGA-99-7458-01A-11D-2035-01")

## Remove title
show_cn_circos(cn, samples = 1, show_title = FALSE)

## Subset chromosomes
show_cn_circos(cn, samples = 1, chrs = c("chr1", "chr2", "chr3"))

## Arrange plots
layout(matrix(1:4, 2, 2))
show_cn_circos(cn, samples = 4)

layout(1) # reset layout
}
}
