% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sig.R
\name{toString.sig}
\alias{toString.sig}
\alias{print.sig}
\title{Print a sig object}
\usage{
\method{toString}{sig}(x, width = getOption("width"), exdent = nchar(x$name), ...)

\method{print}{sig}(x, width = getOption("width"), exdent = nchar(x$name), ...)
}
\arguments{
\item{x}{An object of class \code{sig}.}

\item{width}{Width of string to display.}

\item{exdent}{Non-negative integer specifying the indentation 
of subsequent lines in the string.}

\item{...}{Passed to \code{toString}}
}
\value{
\code{toString} creates a string representation of a
function signature. 
\code{print} is mostly invoked for the side effect of printing 
a function 
signature, invisibly returning its input.
}
\description{
Prints a function signature object.
}
\examples{
print_default_sig <- sig(print.default)
print(print_default_sig)
print(print_default_sig, width = 40)
print(print_default_sig, width = 40, exdent = 2)
toString(print_default_sig)
}
