#' Method for the summary of the STF
#'
#' The STF is obtained with the \eqn{\theta} target procedure implemented in the function \code{theta_target()}
#'
#' @param object Object of class \code{theta_target}
#' @param ... other arguments
#'
#' @returns A summary of the STF obtained from the application of the \eqn{\theta} target procedure
#' @export
#'
#' @examples
#' set.seed(123)
#' n <- 50
#' theta <- rnorm(500)
#' item_par <- data.frame(
#'   b = runif(n, -3, 3),
#'   a = runif(n, 1.2, 1.9),
#'   c = rep(0, n),
#'   e = rep(1, n)
#' )
#' targets <- define_targets(theta, num_targets = 4)
#' resT <- theta_target(targets, item_par)
#' summary(resT)
summary.theta_target <- function(object, ...) {
  cat("The selected items are\n")
  cat(object$stf$isel, "\n")
  cat("These items maximize the information for thetas equal to: \n")
  cat(object$stf$theta_target, "\n with the following parameters \n")
  print(object$selected_items)
  cat("The item selection is based on the theta-target procedure with", object$intervals, "target")
}
