% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aDataScene.R
\name{aDataScene-shiny}
\alias{aDataScene-shiny}
\alias{aDataSceneOutput}
\alias{renderADataScene}
\title{Shiny bindings for aDataScene}
\usage{
aDataSceneOutput(outputId, ..., skipDependencies = FALSE)

renderADataScene(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{...}{Attributes, A-Frame components, and/or child elements for
output in HTML.}

\item{skipDependencies}{Option to omit packaged A-Frame JavaScript
libraries. See details.}

\item{expr}{An expression that returns a call to \code{aDataScene}}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\description{
Output and render functions for using aDataScene within Shiny
applications.
}
\details{
A-Frame v0.7.1, gg-aframe v0.2.3, and
aframe-environment-component v1.0.0 come packaged with
shinyaframe. To use different versions, set \code{skipDependencies}
to \code{TRUE} and source the libraries directly (for
example with \code{\link[htmltools]{includeScript}} or
\code{\link[htmltools]{tag}}).
}
\examples{
# Simple 3D scatterplot.
# See package vignette for additional asethetics, guides, and legends
if (interactive()) {
  library(dplyr)
  library(shiny)
  library(scales)
  shinyApp(
    ui = fluidPage(
      aDataSceneOutput(
        outputId = "mydatascene",
        # gg-aframe plot syntax
        atags$entity(
          plot = "", position = "0 1.6 -1.38", rotation = "0 45 0",
          atags$entity(
            `layer-point` = "", `mod-oscillate` = "",
            `data-binding__sepal.length`="target: layer-point.x",
            `data-binding__sepal.width`="target: layer-point.y",
            `data-binding__petal.length`="target: layer-point.z",
            # add 4th positional by animating y position between two mappings
            `data-binding__petal.width`="target: mod-oscillate.y",
            `data-binding__species`="target: layer-point.shape"
          )
        )
      )
    ),
    server = function(input, output, session) {
      output$mydatascene <- renderADataScene({
        names(iris) <- tolower(names(iris))
        iris \%>\%
          # scale positional data
          mutate_if(is.numeric, rescale) \%>\%
          aDataScene()
      })
    }
  )
}

}
\seealso{
\href{https://github.com/wmurphyrd/gg-aframe#readme}{'gg-aframe' syntax documentation}
}

