% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/doc.R
\name{user}
\alias{user}
\title{user}
\usage{
user(...)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}
}
\value{
An object of class \code{shiny.tag} containing the
necessary configuration and including options such as JavaScript
dependencies to instantiate a HeroUI user component.
}
\description{
Display user information with avatar and name.
}
\details{
\itemize{
\item \bold{name}. Type: \code{string}. Default: \code{NA}.
\item \bold{description}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{isFocusable}. Type: \code{boolean}. Default: \code{false}.
\item \bold{avatarProps}. Type: \code{AvatarProps}. Default: \code{NA}.
\item \bold{classNames}. Type: \code{Partial<Record<"base" OR "wrapper" OR "name" OR "description", string>>}. Default: \code{NA}.
}
}
\examples{
library(shiny)
library(shinyNextUI)
library(shiny.react)

ui <- nextui_page(
  div(
    class = "grid gap-4 grid-cols-3 grid-rows-3 m-5",
    user(
      name = "Jane Doe",
      description = "Product Designer",
      avatarProps = JS("{
        src: 'https://i.pravatar.cc/150?u=a04258114e29026702d'
      }")
    )
  )
)

server <- function(input, output, session) {}

if (interactive() || is_testing()) shinyApp(ui, server)
}
\seealso{
See \url{https://heroui.com/docs/components/user}.
}
