% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc.R, R/inputs.R
\name{listbox}
\alias{listbox}
\alias{listbox_section}
\alias{listbox_item}
\alias{update_listbox}
\title{listbox}
\usage{
listbox(inputId, ..., value = default_value)

listbox_section(...)

listbox_item(...)

update_listbox(session = shiny::getDefaultReactiveDomain(), inputId, ...)
}
\arguments{
\item{inputId}{ID of the component.}

\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}

\item{value}{Starting value.}

\item{session}{Object passed as the \code{session} argument to Shiny server.}
}
\value{
An object of class \code{shiny.tag} containing the
necessary configuration and including options such as JavaScript
dependencies to instantiate a HeroUI listbox component.
}
\description{
A listbox displays a list of options and allows a user to select one or more of them.
}
\details{
\itemize{
\item \bold{children*}. Type: \code{ReactNode[]}. Default: \code{NA}.
\item \bold{items}. Type: \code{Iterable<T>}. Default: \code{NA}.
\item \bold{variant}. Type: \code{solid OR bordered OR light OR flat OR faded OR shadow}. Default: \code{"solid"}.
\item \bold{color}. Type: \code{default OR primary OR secondary OR success OR warning OR danger}. Default: \code{"default"}.
\item \bold{selectionMode}. Type: \code{none OR single OR multiple}. Default: \code{NA}.
\item \bold{selectedKeys}. Type: \code{React.Key[]}. Default: \code{NA}.
\item \bold{disabledKeys}. Type: \code{React.Key[]}. Default: \code{NA}.
\item \bold{defaultSelectedKeys}. Type: \code{all OR React.Key[]}. Default: \code{NA}.
\item \bold{disallowEmptySelection}. Type: \code{boolean}. Default: \code{false}.
\item \bold{shouldHighlightOnFocus}. Type: \code{boolean}. Default: \code{false}.
\item \bold{autoFocus}. Type: \code{boolean OR first OR last}. Default: \code{false}.
\item \bold{topContent}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{bottomContent}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{emptyContent}. Type: \code{ReactNode}. Default: \code{"No items."}.
\item \bold{shouldFocusWrap}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isVirtualized}. Type: \code{boolean}. Default: \code{false}.
\item \bold{virtualization}. Type: \code{Record<"maxListboxHeight" & "itemHeight", number>}. Default: \code{NA}.
\item \bold{hideEmptyContent}. Type: \code{boolean}. Default: \code{false}.
\item \bold{hideSelectedIcon}. Type: \code{boolean}. Default: \code{false}.
\item \bold{disableAnimation}. Type: \code{boolean}. Default: \code{false}.
\item \bold{classNames}. Type: \code{Partial<Record<"base" OR "list" OR "emptyContent", string>>}. Default: \code{NA}.
\item \bold{itemClasses}. Type: \code{Partial<Record<"base" OR "wrapper" OR "title" OR "description" OR "selectedIcon", string>>}. Default: \code{NA}.
}
\itemize{
\item \bold{onAction}. Type: \code{(key: React.Key) => void}. Default: \code{NA}.
\item \bold{onSelectionChange}. Type: \code{(keys: React.Key[]) => void}. Default: \code{NA}.
}
\itemize{
\item \bold{children*}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{title}. Type: \code{string}. Default: \code{NA}.
\item \bold{items}. Type: \code{Iterable<T>}. Default: \code{NA}.
\item \bold{hideSelectedIcon}. Type: \code{boolean}. Default: \code{false}.
\item \bold{showDivider}. Type: \code{boolean}. Default: \code{false}.
\item \bold{dividerProps}. Type: \code{DividerProps}. Default: \code{NA}.
\item \bold{classNames}. Type: \code{Partial<Record<"base" OR "heading" OR "group" OR "divider", string>>}. Default: \code{NA}.
\item \bold{itemClasses}. Type: \code{Partial<Record<"base" OR "wrapper" OR "title" OR "description" OR "shortcut" OR "selectedIcon", string>>}. Default: \code{NA}.
}
\itemize{
\item \bold{children*}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{key}. Type: \code{React.Key}. Default: \code{NA}.
\item \bold{title}. Type: \code{string OR ReactNode}. Default: \code{NA}.
\item \bold{textValue}. Type: \code{string}. Default: \code{NA}.
\item \bold{description}. Type: \code{string OR ReactNode}. Default: \code{NA}.
\item \bold{shortcut}. Type: \code{string OR ReactNode}. Default: \code{NA}.
\item \bold{startContent}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{endContent}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{selectedIcon}. Type: \code{ListboxItemSelectedIconProps}. Default: \code{NA}.
\item \bold{href}. Type: \code{string}. Default: \code{NA}.
\item \bold{target}. Type: \code{HTMLAttributeAnchorTarget}. Default: \code{NA}.
\item \bold{rel}. Type: \code{string}. Default: \code{NA}.
\item \bold{download}. Type: \code{boolean OR string}. Default: \code{NA}.
\item \bold{ping}. Type: \code{string}. Default: \code{NA}.
\item \bold{referrerPolicy}. Type: \code{HTMLAttributeReferrerPolicy}. Default: \code{NA}.
\item \bold{shouldHighlightOnFocus}. Type: \code{boolean}. Default: \code{false}.
\item \bold{hideSelectedIcon}. Type: \code{boolean}. Default: \code{false}.
\item \bold{showDivider}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isDisabled}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isSelected}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isReadOnly}. Type: \code{boolean}. Default: \code{false}.
\item \bold{classNames}. Type: \code{Partial<Record<"base" OR "wrapper" OR "title" OR "description" OR "shortcut" OR "selectedIcon", string>>}. Default: \code{NA}.
}
\itemize{
\item \bold{onAction}. Type: \code{() => void}. Default: \code{NA}.
\item \bold{onPress}. Type: \code{(e: PressEvent) => void}. Default: \code{NA}.
\item \bold{onPressStart}. Type: \code{(e: PressEvent) => void}. Default: \code{NA}.
\item \bold{onPressEnd}. Type: \code{(e: PressEvent) => void}. Default: \code{NA}.
\item \bold{onPressChange}. Type: \code{(isPressed: boolean) => void}. Default: \code{NA}.
\item \bold{onPressUp}. Type: \code{(e: PressEvent) => void}. Default: \code{NA}.
\item \bold{onKeyDown}. Type: \code{(e: KeyboardEvent) => void}. Default: \code{NA}.
\item \bold{onKeyUp}. Type: \code{(e: KeyboardEvent) => void}. Default: \code{NA}.
\item \bold{onClick}. Type: \code{MouseEventHandler}. Default: \code{NA}.
}
}
\examples{
library(shiny)
library(shinyNextUI)
library(shiny.react)

animals <- list(
  list(
    label = "Bulbasaur",
    value = "bulbasaur",
    description = "Blabla",
    avatar = "https://raw.githubusercontent.com/PokeAPI/sprites/master/sprites/pokemon/1.png"
  ),
  list(
    label = "Pikachu",
    value = "pikachu",
    description = "Electric mouse",
    avatar = "https://raw.githubusercontent.com/PokeAPI/sprites/master/sprites/pokemon/25.png"
  )
)

items <- lapply(animals, function(animal) {
  listbox_item(
    key = animal[["value"]],
    description = animal[["description"]],
    startContent = avatar(src = animal[["avatar"]]),
    animal[["label"]]
  )
})

ui <- nextui_page(
  debug_react = TRUE,
  spacer(y = 4),
  action_button("update", "Update to Pikachu?"),
  spacer(y = 4),
  div(
    class = "w-full max-w-[260px] border-small px-1 py-2
    rounded-small border-default-200 dark:border-default-100",
    listbox(
      "listbox",
      label = "Select a pokemon",
      value = "bulbasaur",
      variant = "flat",
      selectionMode = "single",
      listbox_section(
        title = "Default pokemons",
        items
      )
    )
  ),
  textOutput("res")
)

server <- function(input, output, session) {
  output$res <- renderText(input$listbox)
  observeEvent(input$listbox, {
    print(input$listbox)
  })

  observeEvent(input$update, {
    update_listbox(session, "listbox", value = JS("['pikachu']"))
  })
}

if (interactive() || is_testing()) shinyApp(ui, server)
}
\seealso{
See \url{https://heroui.com/docs/components/listbox}.
}
