% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lottie_setSubframe.R
\name{lottie_setSubframe}
\alias{lottie_setSubframe}
\title{Set 'Lottie' Animation Subframe Rendering}
\usage{
lottie_setSubframe(
  flag,
  name = "all",
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{flag}{A logical value specifying whether a 'Lottie' animation should use subframe rendering (\code{TRUE}) or not (\code{FALSE}).}

\item{name}{A character string specifying the name of the 'Lottie' animation to control.
The default of "\code{all}" will control all animations within the 'shiny' application.}

\item{session}{The 'shiny' session object. Defaults to the current reactive domain.}
}
\value{
This function is called for a side effect, and so there is no return value.
}
\description{
Adjust the subframe rendering of a 'Lottie' animation.
}
\details{
Sends a custom session message \code{"lottie_js_setSubframe"} containing the function arguments.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(shiny)
library(shinyLottie)

ui <- fluidPage(
  include_lottie(),
  lottie_animation(
    path = "shinyLottie/example.json",
    name = "my_animation"
  ),
  actionButton("subframeOn", "Subframe On"),
  actionButton("subframeOff", "Subframe Off")
)

server <- function(input, output, session) {
  observeEvent(input$subframeOn, {
    lottie_setSubframe(flag = TRUE, name = "my_animation")
  })

  observeEvent(input$subframeOff, {
    lottie_setSubframe(flag = FALSE, name = "my_animation")
  })
}

shinyApp(ui, server)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{lottie_animation_methods}} for similar methods.
}
