% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lottie_animation.R
\name{lottie_animation}
\alias{lottie_animation}
\title{Generate 'Lottie' Animation for a 'shiny' application}
\usage{
lottie_animation(
  path,
  name,
  loop = TRUE,
  autoplay = TRUE,
  renderer = "svg",
  width = "400px",
  height = "400px",
  ...,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{path}{Either a URL or local file path (see Note).}

\item{name}{A character string specifying the name to give to the animation.}

\item{loop}{Logical indicating whether the animation should loop.}

\item{autoplay}{Logical indicating whether the animation should autoplay.}

\item{renderer}{The renderer to use for the animation, either \code{"svg"}, \code{"canvas"}, or \code{"html"}.}

\item{width}{The width of the animation container. This is validated using \code{\link[htmltools:validateCssUnit]{validateCssUnit}}.}

\item{height}{The height of the animation container. This is validated using \code{\link[htmltools:validateCssUnit]{validateCssUnit}}.}

\item{...}{Additional animation options, including:
\describe{
  \item{\code{speed}}{A numeric specifying the desired animation speed.}
  \item{\code{direction}}{Either \code{1} for forward playback or \code{-1} for reverse playback.}
  \item{\code{setSubFrame}}{A logical value specifying whether a 'Lottie' animation should loop (\code{TRUE}) or not (\code{FALSE}).}
  \item{\code{playSegments}}{A numeric vector or list of numeric vectors indicating the segment(s) to be played.}
  \item{\code{forceFlag}}{Logical value indicating whether to force the animation to play the specified segments immediately (\code{TRUE}) or wait until the current animation completes (\code{FALSE}).}
}}

\item{session}{The 'shiny' session object. Defaults to the current reactive domain.}
}
\value{
A list containing the following elements:
\describe{
  \item{\code{div}}{An HTML \code{div} element serving as the 'Lottie' animation container.}
  \item{\code{script}}{A \code{script} tag containing the 'JavaScript' to initialise the 'Lottie' animation.}
}
}
\description{
Generates a 'Lottie' animation for use within a 'shiny' application.
}
\section{Note}{
 When using a local file path, you may need to use \code{\link[shiny:addResourcePath]{addResourcePath}}.
}

\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(shiny)
library(shinyLottie)

ui <- fluidPage(
  include_lottie(),
  lottie_animation(
    path = "shinyLottie/example.json",
    name = "my_animation"
  )
)

server <- function(input, output, session) {}

shinyApp(ui, server)
\dontshow{\}) # examplesIf}
}
