% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flStandardKnobInput-binding.R
\name{touchKnobInput}
\alias{touchKnobInput}
\title{Highly configurable, touch-enabled knob input for Shiny}
\usage{
touchKnobInput(
  inputId,
  label = NULL,
  labelPosition = "top",
  width = "auto",
  step = "any",
  min = 0,
  max = 1,
  initial = 0.5,
  color = "orange",
  indicatorDot = TRUE,
  indicatorRingType = "positive",
  dragResistance = 100,
  wheelResistance = 100,
  globalRatePolicy = NULL,
  globalRatePolicyDelay = 500
)
}
\arguments{
\item{inputId}{The input slot that will be used to access the value.}

\item{label}{Optional label for knob}

\item{labelPosition}{Position of label ('top' or 'bottom')}

\item{width}{Width of the knob as a percentage of the container element}

\item{step}{The step amount for value changes, usually used with min and max parameters. Can be 'any' (no step)}

\item{min}{The minimum input value.}

\item{max}{The maximum input value.}

\item{initial}{Initial value of the knob. Knob resets to this value when double-clicked.}

\item{color}{The color to use for the indicator ring fill, focus indicator, and indicator dot (if present). You can set any *hex* color (ex : '#0F1BC3') or named color, choices are 'purple', 'blue', 'green', 'yellow', 'red', 'orange' or 'transparent' to disable}

\item{indicatorDot}{Whether the knob should display an indicator dot for making it easier to read the current value. (TRUE or FALSE)}

\item{indicatorRingType}{The fill style for the indicator ring. 'positive' - color fills in from the left as value increases. 'negative' - color fills in from the right as value decreases. 'split' - color fills left/right from middle as value increases/decreases relative to the middle value (half-way between min and max)Type of knob can be 'positive' (clockwise), 'negative' (counter-clockwise) or 'split' (plus/minus vs center position)}

\item{dragResistance}{The amount of resistance to value change on mouse/touch drag events. Higher value means more precision, and the user will have to drag farther to change the input's value. (0 to 100)}

\item{wheelResistance}{The amount of resistance to value change on mouse wheel scroll. Higher value means more precision, and the mouse wheel will be less effective at changing the input's value. (0 to 100)}

\item{globalRatePolicy}{Rate policy determining the behavior of output value events. NULL will output values in real-time, 'debounce' will output values once the knob stops moving, 'throttle' will output values while the knob is moving but only at a certain frequency (controlled with ratePolicyDelay). This setting will affect every touchKnobInput in the project.}

\item{globalRatePolicyDelay}{Delay to use when globalRatePolicy is set to 'throttle' or 'debounce'. This setting will affect every touchKnobInput in the project.}
}
\value{
Numeric value server-side.
}
\description{
Highly configurable, touch-enabled knob input for Shiny
}
\examples{
if (interactive()) {

library("shiny")
library("shinyKnobs")

ui <- fluidPage(
  touchKnobInput(
    inputId = "myKnob",
    label = "A label...",
    initial = 0,
    width = "25\%",
    min = -50,
    max = 50,
    color = "#428BCA"
  ),
  verbatimTextOutput(outputId = "res")
)

server <- function(input, output, session) {

  output$res <- renderPrint(input$myKnob)

}

shinyApp(ui = ui, server = server)

}
}
