% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jseval_and_hooks.R
\name{createStandaloneToast}
\alias{createStandaloneToast}
\title{The `createStandaloneToast` hook}
\usage{
createStandaloneToast()
}
\value{
A list containing some URL-encoded JavaScript code.
}
\description{
The `createStandaloneToast` hook.
}
\details{
See \href{https://chakra-ui.com/docs/feedback/toast#standalone-toasts}{Standalone toasts}.
}
\examples{
library(shiny)
library(shinyChakraUI)

ui <- chakraPage(

  br(),

  chakraComponent(
    "mycomponent",

    withStates(

      Tag$Button(
        colorScheme = "orange",
        size = "lg",
        onClick = jseval(paste(
          '() => {',
          '  const toast = getState("toast");',
          '  toast({',
          '    position: "bottom",',
          '    title: "Account created.",',
          '    description: "We have created your account for you.",',
          '    status: "success",',
          '    duration: 3000,',
          '    isClosable: true',
          '  });',
          '}',
          sep = "\n")),

        "Show toast"
      ),

      states = list(toast = createStandaloneToast())

    )

  )

)

server <- function(input, output, session){}

if(interactive()){
  shinyApp(ui, server)
}
}
