% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twCheckboxGroupInput.R
\name{twCheckboxGroupInput}
\alias{twCheckboxGroupInput}
\title{Wrapper around \code{\link[shiny:checkboxGroupInput]{shiny::checkboxGroupInput()}} but allowing for more classes}
\usage{
twCheckboxGroupInput(
  inputId,
  label,
  choices = NULL,
  selected = NULL,
  inline = FALSE,
  width = NULL,
  container_class = NULL,
  main_label_class = NULL,
  input_class = NULL,
  label_class = NULL,
  inner_container_class = NULL,
  disabled = FALSE
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{choices}{List of values to show checkboxes for. If elements of the list
are named then that name rather than the value is displayed to the user. If
this argument is provided, then \code{choiceNames} and \code{choiceValues}
must not be provided, and vice-versa. The values should be strings; other
types (such as logicals and numbers) will be coerced to strings.}

\item{selected}{The values that should be initially selected, if any.}

\item{inline}{If \code{TRUE}, render the choices inline (i.e. horizontally)}

\item{width}{The width of the input, e.g. \code{'400px'}, or \code{'100\%'};
see \code{\link[shiny:validateCssUnit]{validateCssUnit()}}.}

\item{container_class}{additional classes to be applied to the container}

\item{main_label_class}{additional classes to be applied to the main label}

\item{input_class}{additional classes to be applied to the input element}

\item{label_class}{additional classes to be applied to the label}

\item{inner_container_class}{additional classes to be applied to the container
for each option}

\item{disabled}{if the user should not be able to interact with the field}
}
\value{
a list with a \code{shiny.tag} class
}
\description{
Wrapper around \code{\link[shiny:checkboxGroupInput]{shiny::checkboxGroupInput()}} but allowing for more classes
}
\examples{
shiny::checkboxGroupInput("id", "label", choices = c("A", "B"))
twCheckboxGroupInput("id", "label",
  choices = c("A", "B"),
  width = "200px", disabled = c(TRUE, FALSE),
  container_class = "OUTER.CONTAINER",
  inner_container_class = c("INNER CONTAINER 1", "INNER CONTAINER 2"),
  label_class = c("LABEL 1", "LABEL 2"),
  input_class = "INPUT-ALL"
)

# basic full shiny example
library(shiny)

ui <- fluidPage(
  use_tailwind(),
  twCheckboxGroupInput(
    "chks", "Check all that apply:",
    choices = c("This" = "a", "That" = "b", "None (disabled)" = "c"),
    disabled = c(FALSE, FALSE, TRUE),
    container_class = "w-48 m-4 p-2 border border-gray-200 rounded-md drop-shadow-md",
    label_class = "font-serif text-gray-600",
    input_class = "rounded rounded-full text-pink-500 border-pink-200 focus:ring-pink-500",
  ),
  verbatimTextOutput("out")
)

server <- function(input, output) {
  output$out <- renderText({
    input$chks
  })
}

if (interactive()) shiny::shinyApp(ui, server)
}
\seealso{
\code{\link[shiny:checkboxGroupInput]{shiny::checkboxGroupInput()}}
}
