% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/destroyModule.R
\name{destroyModule}
\alias{destroyModule}
\title{Destroy Shiny Module}
\usage{
destroyModule(id = NULL, session = getDefaultReactiveDomain())
}
\arguments{
\item{id}{The module namespace ID. Use `NULL` to destroy the module the call
is being executed in.}

\item{session}{The shiny session, by default it is `shiny::getDefaultReactiveDomain()`}
}
\value{
No return value, called to remove the relevant module UI and server-side
observers.
}
\description{
Given the namespace of a shiny module, remove all references
to the inputs, outputs and observers that are called within
the module.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(shiny)

basicModuleUI <- function(id) {
  ns <- NS(id)
  actionButton(ns("click"), "Click Button")
}

basicModuleServer <- function(id) {
  moduleServer(id, function(input, output, session) {
    rv <- reactiveVal(0L)
    observeEvent(input$click, rv(rv() + 1L))
    rv
  })
}

destroyableModuleUI <- makeModuleUIDestroyable(basicModuleUI)
destroyableModuleServer <- makeModuleServerDestroyable(basicModuleServer)

ui <- fluidPage(
  destroyableModuleUI(id = "test"),
  actionButton("destroy", "Destroy module"),
  textOutput("reactive_value")
)

server <- function(input, output, session) {
  top_rv <- reactiveVal()
  reactive_value <- destroyableModuleServer("test")
  observeEvent(reactive_value(), top_rv(reactive_value()))

  output$reactive_value <- renderText(top_rv())

  observeEvent(input$destroy, destroyModule("test"))
}

shinyApp(ui, server)
\dontshow{\}) # examplesIf}
}
