#' Matrix of modelled mass accumulation rates per trace element
#'
#' A dataset containing trace element accumulation modelled for every
#' based on the a phase map of the XRF mapped surface of the Crassostrea
#'  gigas #1 oyster used as an example in de Winter (2017)
#'
#' @docType data
#'
#' @usage data(M_el_mat)
#'
#' @format A data frame with 5 rows and 24 variables:
#'
#' \describe{
#'   \item{C}{Mass accumulation of C in subincrement}
#'   \item{O}{Mass accumulation of O in subincrement}
#'   \item{Na}{Mass accumulation of Na in subincrement}
#'   \item{Mg}{Mass accumulation of Mg in subincrement}
#'   \item{Al}{Mass accumulation of Al in subincrement}
#'   \item{Si}{Mass accumulation of Si in subincrement}
#'   \item{P}{Mass accumulation of P in subincrement}
#'   \item{S}{Mass accumulation of S in subincrement}
#'   \item{Cl}{Mass accumulation of Cl in subincrement}
#'   \item{K}{Mass accumulation of K in subincrement}
#'   \item{Ca}{Mass accumulation of Ca in subincrement}
#'   \item{Ti}{Mass accumulation of Ti in subincrement}
#'   \item{Cr}{Mass accumulation of Cr in subincrement}
#'   \item{Mn}{Mass accumulation of Mn in subincrement}
#'   \item{Fe}{Mass accumulation of Fe in subincrement}
#'   \item{Ni}{Mass accumulation of Ni in subincrement}
#'   \item{Cu}{Mass accumulation of Cu in subincrement}
#'   \item{Zn}{Mass accumulation of Zn in subincrement}
#'   \item{Br}{Mass accumulation of Br in subincrement}
#'   \item{Rb}{Mass accumulation of Rb in subincrement}
#'   \item{Sr}{Mass accumulation of Sr in subincrement}
#'   \item{Rh}{Mass accumulation of Rh in subincrement}
#'   \item{Ba}{Mass accumulation of Ba in subincrement}
#'   \item{Pb}{Mass accumulation of Pb in subincrement}
#' }
#' @source \url{https://doi.org/10.5194/gmd-2017-137-supplement}
"M_el_mat"
