% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_match_geometry.R
\name{st_match_geometry}
\alias{st_match_geometry}
\title{Match and set geometry for a data frame}
\usage{
st_match_geometry(source, target, match_field)
}
\arguments{
\item{source}{An sf data frame with a geometry column}

\item{target}{A data frame}

\item{match_field}{A column name (in quotes) for matching, shared by both data frames}
}
\value{
A sf data frame
}
\description{
This function sets the geometry in a target data frame based on matching values in a source data frame
}
\examples{
a <- sf::st_polygon(list(rbind(c(-90,40),c(-90,50),c(-95,50),c(-95,40),c(-90,40))))
b <- sf::st_polygon(list(rbind(c(-80,30),c(-80,20),c(-70,20),c(-70,30),c(-80,30))))
ab <- sf::st_sfc(a,b)
sf::st_crs(ab) <- 4326
source.sf <- data.frame("match_field"=c("A","B"))
sf::st_geometry(source.sf) <- ab
target.df <- data.frame("match_field"=c("A","A","B","C"))
}
\keyword{geometry}
\keyword{map}
\keyword{sf}
\keyword{spatial}
