% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfc_rules.R
\name{sfc_rules}
\alias{sfc_rules}
\title{Constructor of the sfc_rules class}
\usage{
sfc_rules(rules, bases, flip = list(), name = "sfc_rules")
}
\arguments{
\item{rules}{A list of rules.}

\item{bases}{A list of base patterns.}

\item{flip}{A list of rules. They are "flipped" version of \code{rules}. The value can also simply be \code{TRUE}, then
the flipped version is automatically generated from \code{rules}.}

\item{name}{A self-defined string.}
}
\value{
An \code{sfc_rules} object.
}
\description{
Constructor of the sfc_rules class
}
\details{
It is mainly used internally.

\code{rules} is a two-level list. It is in a format of \code{rules[[ base ]][[ expansion_code ]] = sfc_unit()}.
In the following example where we define the expansion rules for the 2x2 curve:

\if{html}{\out{<div class="sourceCode">}}\preformatted{UNIVERSE_2x2 = c("I", "R", "L", "U", "B", "D", "P", "Q", "C")
RULES_2x2 = list()
RULES_2x2[["I"]][[1]] = sfc_unit(c("R", "L", "L", "R"), rot = 0, universe = UNIVERSE_2x2)
}\if{html}{\out{</div>}}

\code{I} is the level-0 base pattern, \verb{[[1]]} corresponds to the first form of expansion to level-1, and the value
assigned is a \code{\link[=sfc_unit]{sfc_unit()}} object which is basically a list of base patterns.

Then we also need to provide the base patterns which define how to extend the curve. The list of base patterns
is assigned to the \code{bases} argument. In the same example, we set \code{bases} as:

\if{html}{\out{<div class="sourceCode">}}\preformatted{list("I" = BASE_I, "R" = BASE_R, "L" = BASE_L, "U" = BASE_U, ...)
}\if{html}{\out{</div>}}

where e.g. \code{\link{BASE_I}} is a pre-defined base pattern in the \code{\link{sfc_base}} class.

There are the following pre-defined rules:
\itemize{
\item \code{\link{SFC_RULES_2x2}}
\item \code{\link{SFC_RULES_3x3_PEANO}}
\item \code{\link{SFC_RULES_3x3_MEANDER}}
\item \code{\link{SFC_RULES_3x3_COMBINED}}
\item \code{\link{SFC_RULES_4x4_MEANDER_1}}
\item \code{\link{SFC_RULES_4x4_MEANDER_2}}
}

Check \url{https://github.com/jokergoo/sfcurve/blob/master/R/zz_global.R} to see how these pre-defined rules are constructed.
}
