% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/builders.R
\name{add_node}
\alias{add_node}
\title{add node to a sewage pipeline}
\usage{
add_node(pipeline, component, name, input, ...)
}
\arguments{
\item{pipeline}{an initialized  sewage pipeline}

\item{component}{a function to be executed. Must be a valid function specification or exported sewage object including \code{Joiner} and \code{Splitter}}

\item{name}{a name to give to the given component. This will be used as the `input` parameter for downstream nodes}

\item{input}{the node to use as input into `component`. Inputs should be either (1) the name of an existing node in the pipeline, or (2) the name(s) of any argument(s) in the first ndoe of the pipeline. These names can be whatever you want, but should match the arguments you pass to \code{run()}}

\item{...}{additional arguments to be passed to the `component` argument}
}
\value{
a \code{sewage_pipeline} object
}
\description{
\code{add_node()} will place a new node in the specified pipeline. This will be executed sequentially when the pipeline is executed using \code{run()}
}
\examples{
my_func = function(df) {
    df \%>\%
        head(15)
}
pipeline = Pipeline()
pipeline = pipeline |>
    add_node(name = 'processor', component = my_func, input = 'file')
}
