% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_seromodel.R
\name{plot_foi_estimates}
\alias{plot_foi_estimates}
\title{Plots Force-of-Infection central estimates}
\usage{
plot_foi_estimates(
  seromodel,
  serosurvey,
  alpha = 0.05,
  foi_df = NULL,
  foi_max = NULL,
  size_text = 11,
  plot_constant = FALSE,
  x_axis = NA
)
}
\arguments{
\item{seromodel}{stan_fit object obtained from sampling a model
with \link{fit_seromodel}}

\item{serosurvey}{\describe{
\item{\code{survey_year}}{Year in which the survey took place
(only needed to plot time models)}
\item{\code{age_min}}{Floor value of the average between age_min and age_max}
\item{\code{age_max}}{The size of the sample}
\item{\code{n_sample}}{Number of samples for each age group}
\item{\code{n_seropositive}}{Number of positive samples for each age group}
}}

\item{alpha}{1 - alpha indicates the credibility level to be used}

\item{foi_df}{Dataframe with columns
\describe{
\item{\code{year}/\code{age}}{Year/Age (depending on the model)}
\item{\code{foi}}{Force-of-infection values by year/age}
}}

\item{foi_max}{Max FoI value for plotting}

\item{size_text}{Size of text for plotting (\code{base_size} in
\link[ggplot2:ggtheme]{ggplot2})}

\item{plot_constant}{boolean specifying whether to plot single
Force-of-Infection estimate and its corresponding rhat value instead
of showing this information in the summary.
Only relevant when \code{seromodel@model_name == "constant"})}

\item{x_axis}{either \code{"time"} or \code{"age"}. Specifies time axis values
label for constant model additional plots. Only relevant when
and \code{seromodel@model_name == "constant"}}
}
\value{
ggplot object with estimated FoI
}
\description{
Plots Force-of-Infection central estimates
}
\examples{
\donttest{
data(chagas2012)
seromodel <- fit_seromodel(
  serosurvey = chagas2012,
  model_type = "time",
  foi_index = data.frame(
    year = 1935:2011,
    foi_index = c(rep(1, 46), rep(2, 31))
  ),
  iter = 100,
  chains = 2
)
plot_foi_estimates(seromodel, chagas2012)
}
}
