% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_bound_ur_i.R
\name{ci_bound_ur}
\alias{ci_bound_ur}
\alias{gen_est_i}
\title{Find a Likelihood-Based
Confidence Bound By Root Finding}
\usage{
ci_bound_ur(
  sem_out,
  func,
  ...,
  level = 0.95,
  which = c("lbound", "ubound"),
  interval = NULL,
  progress = FALSE,
  method = "uniroot",
  lrt_method = "default",
  tol = 5e-04,
  root_target = c("chisq", "pvalue"),
  d = 5,
  uniroot_extendInt = switch(which, lbound = "downX", ubound = "upX"),
  uniroot_trace = 0,
  uniroot_maxiter = 1000,
  use_callr = TRUE,
  rs = NULL
)

gen_est_i(i, sem_out, standardized = FALSE)
}
\arguments{
\item{sem_out}{The fit object.
Currently supports
\link[lavaan:lavaan-class]{lavaan::lavaan} objects only.}

\item{func}{A function that receives
a lavaan object and returns a scalar.
This function is to be used by
\code{\link[=gen_userp]{gen_userp()}} and so there are
special requirements on it.
Alternatively, it can be the output
of \code{\link[=gen_est_i]{gen_est_i()}}.}

\item{...}{Optional arguments to be
passed to \code{func}. Usually not used
but included in case the function
has such arguments.}

\item{level}{The level of confidence
of the confidence interval. Default
is .95, or 95\%.}

\item{which}{Whether the lower bound
or the upper bound is to be found.
Must be \code{"lbound"} or \code{"ubound"}.}

\item{interval}{A numeric vector of
two values, which is the initial
interval to be searched. If \code{NULL},
the default, it will be determined
internally using Wald or delta
method confidence interval, if
available.}

\item{progress}{Whether progress will
be reported on screen during the
search. Default is
\code{FALSE}.}

\item{method}{The actual function to
be used in the search. which can only
be \code{"uniroot"}, the default, for now.
May include other function in the
future.}

\item{lrt_method}{The method used in
\code{\link[lavaan:lavTestLRT]{lavaan::lavTestLRT()}}. Default is
\code{"default"}. It is automatically set
to \code{"satorra.2000"} and cannot be
overridden if a scaled test statistic
is requested in \code{sem_out}.}

\item{tol}{The tolerance used in
\code{\link[=uniroot]{uniroot()}}, default is .005.}

\item{root_target}{Whether the
chi-square difference (\code{"chisq"}),
the default, or its \emph{p}-value
(\code{"pvalue"}) is used as the function
value in finding the root. Should have
little impact on the results.}

\item{d}{A value used to determine
the width of the interval in the
initial search. Larger this value,
\emph{narrow} the interval. Default is 5.}

\item{uniroot_extendInt}{To be passed
to the argument \code{extendInt} of
\code{\link[=uniroot]{uniroot()}}. Whether the interval
should be extended if the root is not
found. Default value depends on
the bound to be searched. Refer to
the help page of \code{\link[=uniroot]{uniroot()}} for
possible values.}

\item{uniroot_trace}{To be passed to
the argument \code{trace} of \code{\link[=uniroot]{uniroot()}}.
How much information is printed
during the search. Default is 0, and
no information is printed during the
search. Refer to the help page of
\code{\link[=uniroot]{uniroot()}} for possible values.}

\item{uniroot_maxiter}{The maximum
number of iteration in the search.
Default is 1000.}

\item{use_callr}{Whether the
\code{callr} package will be used to
do the search in a separate R
process. Default is \code{TRUE}. Should
not set to \code{FALSE} if used in an
interactive environment unless this is
intentional.}

\item{rs}{Optional. If set to
a persistent R process created by
\code{callr}, it will be used instead of
starting a new one, and it will not
be terminated on exit.}

\item{i}{The position of the target
parameter as appeared in the
parameter table of an lavaan object,
generated by
\code{\link[lavaan:parTable]{lavaan::parameterTable()}}.}

\item{standardized}{If \code{TRUE}, the
standardized estimate is to be
retrieved. Default is \code{FALSE}.
Only support \code{"std.all"} for now.}
}
\value{
The function \code{\link[=ci_bound_ur]{ci_bound_ur()}} returns
a list with the following elements:
\itemize{
\item \code{bound}: The bound found.
\item \code{optimize_out}: THe output of the
root finding function, \code{\link[=uniroot]{uniroot()}}
for now. (Called \code{optimize_out}
because an earlier version of this
function also uses \code{\link[=optimize]{optimize()}}).
\item \code{sem_out_bound}: The \code{lavaan} model
with the user-defined parameter fixed
to the bound.
\item \code{lrt}: The output of
\code{\link[lavaan:lavTestLRT]{lavaan::lavTestLRT()}} comparing
\code{sem_out} and \code{sem_out_bound}.
\item \code{bound_start}: The Wald or delta
method confidence bound returned when
determining the interval internally.
\item \code{user_est}: The estimate of the
user-defined parameter when
determining the interval internally.
}

The function \code{\link[=gen_est_i]{gen_est_i()}} returns
a special function can inspects the
\code{Model} slot (and \code{implied} slot
if necessary) of a modified \code{lavaan}
object and return the parameter
estimate. This function is to be used
by \code{\link[=ci_bound_ur]{ci_bound_ur()}} or
\code{\link[=gen_sem_out_userp]{gen_sem_out_userp()}}.
}
\description{
Find the lower or upper
bound of the likelihood-based
confidence interval (LBCI) for one
parameter in a structural equation
model fitted in \code{\link[lavaan:lavaan]{lavaan::lavaan()}}
using \code{\link[=uniroot]{uniroot()}}.
}
\details{
This function is called xby
\code{\link[=ci_bound_ur_i]{ci_bound_ur_i()}}. This function is
exported because it is a
stand-alone function that can be used
directly for any function that
receives a lavaan object and returns
a scalar.

The function \code{\link[=ci_bound_ur_i]{ci_bound_ur_i()}} is a
wrapper of this function, with an
interface similar to that of
\code{\link[=ci_bound_wn_i]{ci_bound_wn_i()}} and returns a
\code{cibound}-class object. The
user-parameter function is generated
internally by \code{\link[=ci_bound_wn_i]{ci_bound_wn_i()}}.

This function, on the other hand,
requires users to supply the function
directly through the \code{func} argument.
This provides the flexibility to find
the bound for any function of the
model parameter, even one that cannot
be easily coded in \code{lavaan} model
syntax.
}
\examples{

library(lavaan)
data(simple_med)
dat <- simple_med
mod <-
"
m ~ x
y ~ m
"
fit_med <- lavaan::sem(mod, simple_med, fixed.x = FALSE)
parameterTable(fit_med)
# Create a function to get the second parameter
est_i <- gen_est_i(i = 2, sem_out = fit_med)
# Find the lower bound of the likelihood-based confidence interval
# of the second parameter.
# user_callr should be TRUE or omitted in read research.
# Remove interval in read research. It is added to speed up the example.
out1l <- ci_bound_ur(sem_out = fit_med,
                     func = est_i,
                     which = "lbound",
                     use_callr = FALSE,
                     interval = c(.39070, .39075))
out1l

}
