% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semidist.R
\name{sdcov}
\alias{sdcov}
\alias{sdcor}
\title{Semi-distance covariance and correlation statistics}
\usage{
sdcov(X, y, type = "V", return_mat = FALSE)

sdcor(X, y)
}
\arguments{
\item{X}{Data of multivariate continuous variables, which should be an
\eqn{n}-by-\eqn{p} matrix, or, a vector of length \eqn{n} (for univariate
variable).}

\item{y}{Data of categorical variables, which should be a factor of length
\eqn{n}.}

\item{type}{Type of statistic: \code{"V"} (the default) or \code{"U"}. See Details.}

\item{return_mat}{A boolean. If \code{FALSE} (the default), only the calculated
statistic is returned. If \code{TRUE}, also return the matrix of the distances
of X and the divergences of y, which is useful for the permutation test.}
}
\value{
The value of the corresponding sample statistic.

If the argument \code{return_mat} of \code{sdcov()} is set as \code{TRUE}, a list with
elements
\itemize{
\item \code{sdcov}: the semi-distance covariance statistic;
\item \verb{mat_x, mat_y}: the matrices of the distances of X and the divergences
of y, respectively;
}

will be returned.
}
\description{
Compute the statistics (or sample estimates) of semi-distance
covariance and correlation. The semi-distance correlation is a standardized
version of semi-distance covariance, and it can measure the dependence
between a \emph{multivariate} continuous variable and a categorical variable.
See Details for the definition of semi-distance covariance and
semi-distance correlation.
}
\details{
For \eqn{\bm{X} \in \mathbb{R}^{p}} and \eqn{Y \in \{1, 2, \cdots,
  R\}}, the (population-level) semi-distance covariance is defined as
\deqn{\mathrm{SDcov}(\bm{X}, Y) =
  \mathrm{E}\left[\|\bm{X}-\widetilde{\bm{X}}\|\left(1-\sum_{r=1}^R
  I(Y=r,\widetilde{Y}=r)/p_r\right)\right],} where \eqn{p_r = P(Y = r)} and
\eqn{(\widetilde{\bm{X}}, \widetilde{Y})} is an iid copy of \eqn{(\bm{X},
  Y)}.
The (population-level) semi-distance correlation is defined as
\deqn{\mathrm{SDcor}(\bm{X}, Y) = \dfrac{\mathrm{SDcov}(\bm{X},
  Y)}{\mathrm{dvar}(\bm{X})\sqrt{R-1}},} where \eqn{\mathrm{dvar}(\bm{X})} is
the distance variance (Szekely, Rizzo, and Bakirov 2007) of \eqn{\bm{X}}.

With \eqn{n} observations \eqn{\{(\bm{X}_i, Y_i)\}_{i=1}^{n}}, \code{sdcov()}
and \code{sdcor()} can compute the sample estimates for the semi-distance
covariance and correlation.

If \code{type = "V"}, the semi-distance covariance statistic is computed as a
V-statistic, which takes a very similar form as the energy-based statistic
with double centering, and is always non-negative. Specifically,
\deqn{\text{SDcov}_n(\bm{X}, y) = \frac{1}{n^2} \sum_{k=1}^{n}
  \sum_{l=1}^{n} A_{kl} B_{kl},}
where \deqn{A_{kl} = a_{kl} - \bar{a}_{k.} - \bar{a}_{.l} + \bar{a}_{..}}
is the double centering (Szekely, Rizzo, and Bakirov 2007) of
\eqn{a_{kl} = \| \bm{X}_k - \bm{X}_l \|,} and \deqn{B_{kl} =
  1 - \sum_{r=1}^{R} I(Y_k = r) I(Y_l = r) / \hat{p}_r} with \eqn{\hat{p}_r =
  n_r / n = n^{-1}\sum_{i=1}^{n} I(Y_i = r)}.
The semi-distance correlation statistic is \deqn{\text{SDcor}_n(\bm{X}, y)
  = \dfrac{\text{SDcov}_n(\bm{X}, y)}{\text{dvar}_n(\bm{X})\sqrt{R - 1}},}
where \eqn{\text{dvar}_n(\bm{X})} is the V-statistic of distance variance
of \eqn{\bm{X}}.

If \code{type = "U"}, then the semi-distance covariance statistic is computed as
an ``estimated U-statistic'', which is utilized in the independence test
statistic and is not necessarily non-negative. Specifically,
\deqn{\widetilde{\text{SDcov}}_n(\bm{X}, y) = \frac{1}{n(n-1)}
  \sum_{i \ne j} \| \bm{X}_i - \bm{X}_j \| \left(1 - \sum_{r=1}^{R}
  I(Y_i = r) I(Y_j = r) / \tilde{p}_r\right),}
where \eqn{\tilde{p}_r = (n_r-1) / (n-1) = (n-1)^{-1}(\sum_{i=1}^{n} I(Y_i
  = r) - 1)}. Note that the test statistic of the semi-distance independence
test is \deqn{T_n = n \cdot \widetilde{\text{SDcov}}_n(\bm{X}, y).}
}
\examples{
X <- mtcars[, c("mpg", "disp", "drat", "wt")]
y <- factor(mtcars[, "am"])
print(sdcov(X, y))
print(sdcor(X, y))

# Man-made independent data -------------------------------------------------
n <- 30; R <- 5; p <- 3; prob <- rep(1/R, R)
X <- matrix(rnorm(n*p), n, p)
y <- factor(sample(1:R, size = n, replace = TRUE, prob = prob), levels = 1:R)
print(sdcov(X, y))
print(sdcor(X, y))

# Man-made functionally dependent data --------------------------------------
n <- 30; R <- 3; p <- 3
X <- matrix(0, n, p)
X[1:10, 1] <- 1; X[11:20, 2] <- 1; X[21:30, 3] <- 1
y <- factor(rep(1:3, each = 10))
print(sdcov(X, y))
print(sdcor(X, y))

}
\seealso{
\itemize{
\item \code{\link[=sd_test]{sd_test()}} for implementing independence test via semi-distance
covariance;
\item \code{\link[=sd_sis]{sd_sis()}} for implementing groupwise feature screening via
semi-distance correlation.
}
}
