\name{nodeProbabilities}
\alias{nodeProbabilities}



\title{Multiplies conditional probabilities along all branches of the tree}

\description{This function generates the symbolic formulas representing
  the marginal node probabilities.}


\usage{
nodeProbabilities(F,generation)
}

\arguments{

  \item{F}{A recurrent selfing tree, as generated by function
    \code{buildSelfingTree}.}

  \item{generation}{Integer giving the highest selfing generation contained
    in \code{F}. Values can range from 2 to 7, e.g., the F2 generation
    build by default and the highest possible generation is currently the
    F7.}
}


\value{A \code{list} with as many elements as there were generations in
\code{F}. The list elements are named "F2", "F3", etc. Each element is a
vector with the symbolic formulas for the marginal probabilities of all
possible nodes. The vector elements are named
and the names indicate the allelic configuration of the two gametes
comprising the genotype as \code{gamete1-gamete2} (e.g.,
\code{"AAB-AAA"}).  }

\details{Each formula represents the marginal probability of a
  particular node. Summing over all nodes for a particular genotype
  gives the probability of observing this genotype in this
  generation. The sum over all marginal node probabilities within a
  generation is 1.}
  
\author{
  Frank Technow
}

\examples{

## F2 and F3 genotypes
node.probs <- nodeProbabilities(buildSelfingTree(genSubtree.2M,3,"AA","BB"),3)

## must sum to 1
stopifnot(all.equal(evalProb(node.probs[["F2"]],z = 0.045),1))
stopifnot(all.equal(evalProb(node.probs[["F3"]],z = 0.045),1))

}


