% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_tu_tudtc_visit_ordinal_error.R
\name{check_tu_tudtc_visit_ordinal_error}
\alias{check_tu_tudtc_visit_ordinal_error}
\title{Check that all TU  dates are duplicated or earlier than last
visit's (possible datetime data entry error)}
\usage{
check_tu_tudtc_visit_ordinal_error(TU)
}
\arguments{
\item{TU}{Tumor Identification SDTM dataset with variables USUBJID,TUORRES ,TULOC, VISITNUM, VISIT, TUDTC, TUEVAL}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check identifies TUDTC values that are duplicated or
earlier than last visit's. Unscheduled visits are excluded.
}
\examples{

# no case
TU <- data.frame(USUBJID = 101:102,
                TUORRES = rep(c("NEW", "TARGET"), 5),
                TULOC=rep(c("BONE","LIVER"),5),
                TUDTC = rep(c("2017-01-01T08:25", "2017-01-05T09:25",
                 "2017-01-15T10:25","2017-01-20T08:25","2017-01-25T08:25"), 2),
                VISITNUM = rep(1:5,2),
                VISIT = rep(c( "Visit 1", "Visit 2", "Visit 3", "Visit 4","VIsit 5"), 2),
                TUEVAL="INVESTIGATOR",
                stringsAsFactors = FALSE)
check_tu_tudtc_visit_ordinal_error(TU)

# adding cases with earler date
TU$TUDTC[TU$USUBJID == 101 & TU$VISIT == "Visit 4"] <- "2017-01-10T08:25"
TU$TUDTC[TU$USUBJID == 102 & TU$VISIT == "Visit 2"] <- "2017-01-01T06:25"
check_tu_tudtc_visit_ordinal_error(TU)

# adding cases with duplicated date
TU$TUDTC[TU$USUBJID == 101 & TU$VISIT == "Visit 5"] <- "2017-01-10T08:25"
TU$TUDTC[TU$USUBJID == 102 & TU$VISIT == "Visit 3"] <- "2017-01-01T06:25"
 check_tu_tudtc_visit_ordinal_error(TU)
}
\author{
Jingyuan Chen
}
