% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ts_cmdict.R
\name{check_ts_cmdict}
\alias{check_ts_cmdict}
\title{Check for missing WHODrug version in TS}
\usage{
check_ts_cmdict(TS)
}
\arguments{
\item{TS}{Trial Summary SDTM dataset with variables TSPARMCD and TSVAL}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check looks for missing WHODrug version;
if it's present, also checking it's the current version
}
\examples{

TS1 <- data.frame(
 STUDYID = 1,
 TSPARMCD = "CMDICT",
 TSVAL = "WHODRUG GLOBAL B3 MARCH 1, 2021",
 TSVAL2 = ""
)

TS2 <- data.frame(
 STUDYID = 2,
 TSPARMCD = "CMDICT",
 TSVAL = "",
 TSVAL1 = "WHODRUG GLOBAL B3 MARCH 1, 2021"
)

TS3 <- data.frame(
 STUDYID = 3,
 TSPARMCD = "CMDICT",
 TSVAL = ""
)

TS4 <-data.frame(
 STUDYID = 4,
 TSPARMCD = "AEDICT",
 TSVAL = ""
)

TS5 <- data.frame(
    STUDYID = 5,
    TSPARMCD = "CMDICT",
    TSVAL = "meddra 24.0",
    TSVAL2 = ""
)

TS6 <- data.frame(
 STUDYID = 6,
 TSPARMCD = "CMDICT",
 TSVAL = "WHODRUG vGLOBAL B3 MARCH 1, 2021",
 TSVAL2 = ""
)

check_ts_cmdict(TS1)
check_ts_cmdict(TS2)
check_ts_cmdict(TS3)
check_ts_cmdict(TS4)
check_ts_cmdict(TS5)
check_ts_cmdict(TS6)
check_ts_cmdict(rbind(TS1,TS1))
}
\author{
Antony Howard (HackR 2021 Team Pentraxin1)
}
