% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_lb_lbstresc_char.R
\name{check_lb_lbstresc_char}
\alias{check_lb_lbstresc_char}
\title{Check LBORRES/LBSTRESC populated with number beginning with
character '>' or '<', which will yield missing AVAL in ADaM and records will be omitted in analyses such as Hy's Law}
\usage{
check_lb_lbstresc_char(LB)
}
\arguments{
\item{LB}{Lab SDTM dataset with variables USUBJID, LBTEST, LBDTC, LBORRES, LBORRESU, LBSTRESN, LBSTRESC}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check looks for missing numeric standardized finding (LBSTRESN)
when original finding (LBORRES) and character standardized finding (LBSTRESC) are not missing
and LBORRES/LBSTRESC populated with number beginning with character '>' or '<'
}
\examples{

 LB <- data.frame(
 USUBJID = c("Patient 1","Patient 2","Patient 3"),
 LBTEST   = "Test A",
 LBDTC   = "2017-01-01",
 LBORRES = c("5","3","7"),
 LBORRESU = rep("mg",3),
 LBSTRESC  = c("5","3","7"),
 LBSTRESN  = c(5,3,7),
 stringsAsFactors = FALSE
)

check_lb_lbstresc_char(LB)

 LB <- data.frame(
 USUBJID = c("Patient 1","Patient 2","Patient 3"),
 LBTEST   = rep("Test A", 3),
 LBDTC   = "2017-01-01",
 LBORRES = c("5","3","<7"),
 LBORRESU = rep("mg",3),
 LBSTRESC  = c("5","3","<7"),
 LBSTRESN  = c(5,3,NA),
 stringsAsFactors = FALSE
)

check_lb_lbstresc_char(LB)

LB <- data.frame(
 USUBJID = c("Patient 1","Patient 2","Patient 3"),
 LBTEST   = rep("Test A", 3),
 LBDTC   = rep("2017-01-01", 3),
 LBORRES = c("5","BLQ","<7"),
 LBORRESU = rep("mg",3),
 LBSTRESC  = c("5","BLQ","<7"),
 LBSTRESN  = c(5,NA,NA),
 stringsAsFactors = FALSE
)

check_lb_lbstresc_char(LB)


}
\author{
Vira Vrakina
}
