% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pd.boots.R
\name{pd.boots}
\alias{pd.boots}
\title{Select the model parameters using Fourier transformation method.}
\usage{
pd.boots(y, p_list=seq(2,6,by=1), w1=0.1,  space = "mean",std = FALSE,
                                     density = "kernel", method = "FM", B=50)
}
\arguments{
\item{y}{A univariate time series observations.}

\item{p_list}{(default \{2,3,4,5,6\}). The candidate list of the number of lags, p.}

\item{w1}{(default 0.1). The tuning parameter of the estimation.}

\item{space}{(default ``mean''). Specify the SDR subspace needed to be estimated.}

\item{std}{(default FALSE). If TRUE, then standardizing the time series observations.}

\item{density}{(default ``kernel''). Density function for the estimation (``kernel'' or ``normal'').}

\item{method}{(default ``FM''). Estimation method (``FM'' or ``NW'').}

\item{B}{(default 50). Number of block bootstrap sample.}
}
\value{
The output is a p-by-p matrix, estimated p and d.
\item{dis_dp}{The average block bootsrap distances.}

\item{p_hat}{The estimator for p.}

\item{d_hat}{The estimator for d.}
}
\description{
`pd.boots()' estimates the number of lags in the model and the dimension of the time series central mean subspace.
}
\examples{
\donttest{
data("lynx")
y <- log10(lynx)
p_list=seq(2,5,by=1)
fit.model=pd.boots(y,p_list,w1=0.1,B=10)
fit.model$dis_pd
fit.model$p_hat
fit.model$d_hat
}
}
\references{
Samadi S. Y. and  De Alwis T. P. (2023). Fourier Method of Estimating Time Series Central Mean Subspace.
\emph{https://arxiv.org/pdf/2312.02110}.
}
