% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_sdl_datasets.R
\docType{data}
\name{pss}
\alias{pss}
\title{Stress in Prison}
\format{
A data frame with 26 observations on the following 4 variables.

\itemize{
\item \code{group}: a factor, which identifies whether the individual belongs to the control or the experimental group.
\item \code{pss_before}: stress measurement before training.
\item \code{pss_after}: stress measurement before training.
\item \code{difference}: the difference between the stress levels obtained
 at the end of the experiment and at the beginning, that is, \code{pss_after - pss_before}.
}
}
\usage{
data(pss)
}
\description{
This data set consists of the stress levels presented by
 26 individuals in an experimental study conducted by Verdot et al. (2010)
 in a French penitentiary. The inmates were divided into two groups,
 one formed by individuals who spontaneously opted to practice sports;
 and another one with those who did not wish to perform physical activity.
 The observations consist of the stress levels presented by detainees
 at the beginning and end of the experiment.
}
\details{
To measure the stress level, Verdot et al (2010) used the
Perceived Stress Scale (PSS) (Cohen, Kamarck and Mermelstein, 1983),
 which is a discrete scale and one of the most used psychological
 tools to measure the levels of perceived non-specific stress in an
 individual.
}
\references{
Cohen, S., Kamarck, T., and Mermelstein, R. (1983). A
    global measure of perceived stress. \emph{Journal of Health and Social
    Behavior}, \bold{24}, 385---396.

Verdot, C., Champely, S., Clément, M., and Massarelli, R. (2010).
    A simple tool to ameliorate detainees’ mood and well-being in prison: Physical activities.
    \emph{International Review on Sport & Violence}, \bold{2}, 83---93.
}
\keyword{datasets}
