% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06_choose_mode.R
\name{choose_mode}
\alias{choose_mode}
\alias{print.choose_mode}
\alias{plot.choose_mode}
\title{Choose the Mode of the Modified Skew Discrete Laplace Regression}
\usage{
choose_mode(
  object,
  grid = -5:5,
  trace = TRUE,
  plot = TRUE,
  control = sdl_control(...),
  ...
)

\method{print}{choose_mode}(x, ...)

\method{plot}{choose_mode}(x, ...)
}
\arguments{
\item{object}{an object of class \code{"sdlrm"}, a result of a call to \code{\link{sdlrm}}.}

\item{grid}{grid of values that will be used to evaluate the profile log-likelihood function.}

\item{trace}{logical; if \code{TRUE}, a summary with the profile log-likelihood value, the AIC,
and the BIC of the fit is displayed.}

\item{plot}{logical; if \code{TRUE}, a graph of the profiled log-likelihood evaluated in the
considered grid of values is shown.}

\item{control}{a list of control arguments specified via \code{\link{sdl_control}}.}

\item{...}{further arguments passed to \code{\link{sdl_control}}.}

\item{x}{an object of class \code{"choose_mode"}.}
}
\value{
An object of class \code{"choose_mode"}. More specifically, it returns a list in which
    each element consists of the fit of the modified SDL regression with each value of the mode
    specified in \code{grid}. In addition, it has the elements \code{“logLik”} with the vector
    of log-likelihood values for each adjustment and \code{“grid”} with the specified grid of
    values.

    The \code{print} function summarizes the fits by displaying, for each value in \code{grid},
    the log-likelihood value and the Akaike (AIC) and Bayesian (BIC) information criteria. The
    \code{plot} function returns a graph of the profiled likelihood of the mode, highlighting its
    maximum.
}
\description{
Estimation of the mode in a modified skew discrete Laplace (SDL) regression fit
    via profile log-likelihood.
}
\examples{
# Data set: pss (for description run ?pss)
barplot(table(pss$difference), xlab = "PSS index difference", ylab = "Frequency")
boxplot(pss$difference ~ pss$group, xlab = "Group", ylab = "PSS index difference")

# Fit with a model only for the mean with xi = 0 (default)
fit0 <- sdlrm(difference ~ group, data = pss)

# Choosing the mode on the grid {-10, -9, ..., 0, ..., 9, 10}
fit <- choose_mode(fit0, grid = -10:10)

# Class
class(fit)

# It is possible to recovery the plot:
plot(fit)

# and the trace:
fit

# Fit with xi = 1
fit[[1]]
}
\references{
Medeiros, R. M. R., and Bourguignon, M. (2025). Modified skew discrete Laplace
    regression models for integer valued data with applications to paired samples.
    \emph{Manuscript submitted for publication.}
}
\author{
Rodrigo M. R. de Medeiros <\email{rodrigo.matheus@ufrn.br}>
}
