% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate}
\alias{simulate}
\title{Simulate stock-and-flow model}
\usage{
simulate(
  sfm,
  keep_nonnegative_flow = TRUE,
  keep_nonnegative_stock = FALSE,
  keep_unit = TRUE,
  only_stocks = TRUE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{sfm}{Stock-and-flow model, object of class \code{\link[=xmile]{sdbuildR_xmile}}.}

\item{keep_nonnegative_flow}{If TRUE, keeps original non-negativity setting of flows. Defaults to TRUE.}

\item{keep_nonnegative_stock}{If TRUE, keeps original non-negativity setting of stocks Defaults to FALSE.}

\item{keep_unit}{If TRUE, keeps units of variables. Defaults to TRUE.}

\item{only_stocks}{If TRUE, only return stocks in output, discarding flows and auxiliaries. If FALSE, flows and auxiliaries are saved, which slows down the simulation. Defaults to FALSE.}

\item{verbose}{If TRUE, print duration of simulation. Defaults to FALSE.}

\item{...}{Optional arguments}
}
\value{
Object of class \code{\link[=simulate]{sdbuildR_sim}}, a list containing:
\describe{
\item{df}{Data frame: simulation results (time, variable, value)}
\item{init}{Named vector: initial stock values}
\item{constants}{Named vector: constant parameters}
\item{script}{Character: generated simulation code (R or Julia)}
\item{duration}{Numeric: simulation time in seconds}
\item{success}{Logical: TRUE if completed without errors}
\item{...}{Other parameters passed to simulate}
}

Use \code{\link[=as.data.frame]{as.data.frame()}} to extract results, \code{\link[=plot]{plot()}} to visualize.
}
\description{
Simulate a stock-and-flow model with simulation specifications defined by \code{\link[=sim_specs]{sim_specs()}}. If \code{sim_specs(language = "julia")}, the Julia environment will first be set up with \code{\link[=use_julia]{use_julia()}}. If any problems are detected by \code{\link[=debugger]{debugger()}}, the model cannot be simulated.
}
\examples{
sfm <- xmile("SIR")
sim <- simulate(sfm)
plot(sim)

# Obtain all model variables
sim <- simulate(sfm, only_stocks = FALSE)
plot(sim, add_constants = TRUE)

\dontshow{if (julia_status()$status == "ready") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Use Julia for models with units
sfm <- sim_specs(xmile("coffee_cup"), language = "Julia")
sim <- simulate(sfm)
plot(sim)

# Close Julia session
use_julia(stop = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=build]{build()}}, \code{\link[=xmile]{xmile()}}, \code{\link[=debugger]{debugger()}}, \code{\link[=sim_specs]{sim_specs()}}, \code{\link[=use_julia]{use_julia()}}
}
\concept{simulate}
