% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_sd.R
\name{sample_sd}
\alias{sample_sd}
\title{Compute the sample standard deviation}
\usage{
sample_sd(x, na.rm = FALSE)
}
\arguments{
\item{x}{Numeric vector}

\item{na.rm}{(logical) Should missing values be removed?}
}
\value{
A single numeric value equal to the sample variance
}
\description{
\code{sample_sd} computes the sample standard deviation, i.e. the square root of the sum of squared deviations of \code{x} from the mean divided by the total number of observations. This is in contrast to \code{sd}, which computes an unbiased estimate of the standard deviation (i.e. it divides the sum of squared deviations by n - 1).
}
\examples{
data(anchoring)
sample_sd(anchoring$everest_feet)
}
