% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/undersample.R
\name{undersample_hclust}
\alias{undersample_hclust}
\title{Undersample a dataset by hierarchical clustering.}
\usage{
undersample_hclust(data, cls, cls_col, m, k = 5, h = NA, ...)
}
\arguments{
\item{data}{Dataset to be undersampled.}

\item{cls}{Majority class that will be undersampled.}

\item{cls_col}{Column in data containing class memberships.}

\item{m}{Number of samples in undersampled dataset.}

\item{k}{Number of clusters to derive from clustering.}

\item{h}{Height at which to cut the clustering tree. \code{k} must be \code{NA} for this to be used.}

\item{...}{Additional arguments passed to \code{\link[stats]{dist}()}.}
}
\value{
Undersampled dataframe containing only \code{cls}.
}
\description{
Undersample a dataset by hierarchical clustering.
}
\examples{
table(iris$Species)
undersamp <- undersample_hclust(iris, "setosa", "Species", 15)
nrow(undersamp)
}
