% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-catalogs.R
\name{scry-catalogs}
\alias{scry-catalogs}
\alias{scry_catalog}
\title{Retrieve catalog objects}
\usage{
scry_catalog(name)
}
\arguments{
\item{name}{A string with the name of the catalog to return. Can be one of:
\itemize{
\item \code{card-names}: Returns all nontoken English card names in Scryfall's
database. Values are updated as soon as a new card is entered for spoiler
seasons.
\item \code{artist-names}: Returns all canonical artist names in Scryfall's database.
This catalog won't include duplicate, misspelled, or funny names for
artists. Values are updated as soon as a new card is entered for spoiler
seasons.
\item \code{word-bank}: Returns all English words, of length 2 or more, that could
appear in a card name. Values are drawn from cards currently in Scryfall's
database. Values are updated as soon as a new card is entered for spoiler
seasons.
\item \code{creature-types}: Returns all creature types in Scryfall's database. Values
are updated as soon as a new card is entered for spoiler seasons.
\item \code{planeswalker-types}: Returns all Planeswalker types in Scryfall's
database. Values are updated as soon as a new card is entered for spoiler
seasons.
\item \code{land-types}: Returns all Land types in Scryfall's database. Values are
updated as soon as a new card is entered for spoiler seasons.
\item \code{artifact-types}: Returns all artifact types in Scryfall's database. Values
are updated as soon as a new card is entered for spoiler seasons.
\item \code{enchantment-types}: Returns all enchantment types in Scryfall's database.
Values are updated as soon as a new card is entered for spoiler seasons.
\item \code{spell-types}: Returns all spell types in Scryfall's database. Values are
updated as soon as a new card is entered for spoiler seasons.
\item \code{powers}: Returns all possible values for a creature or vehicle's power in
Scryfall's database. Values are updated as soon as a new card is entered
for spoiler seasons.
\item \code{toughnesses}: Returns all possible values for a creature or vehicle's
toughness in Scryfall's database. Values are updated as soon as a new card
is entered for spoiler seasons.
\item \code{loyalties}: Returns all possible values for a Planeswalker's loyalty in
Scryfall's database. Values are updated as soon as a new card is entered
for spoiler seasons.
\item \code{watermarks}: Returns all card watermarks in Scryfall's database. Values
are updated as soon as a new card is entered for spoiler seasons.
\item \code{keyword-abilities}: Returns all keyword abilities in Scryfall's database.
Values are updated as soon as a new card is entered for spoiler seasons.
\item \code{keyword-actions}: Returns all keyword actions in Scryfall's database.
Values are updated as soon as a new card is entered for spoiler seasons.
\item \code{ability-words}: Returns all ability words in Scryfall's database. Values
are updated as soon as a new card is entered for spoiler seasons.
}}
}
\value{
A string vector.
}
\description{
Scryfall has multiple catalog datapoints (words, card values, etc). They are
provided by the API as aids for building other \emph{Magic} software and
understanding possible values for a column.
}
\examples{
\donttest{
# Get information from a catalog
scry_catalog("keyword-actions")
}

}
\references{
\url{https://scryfall.com/docs/api/catalogs}
}
