% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function-factory-helpers.R
\name{check_args_disabled}
\alias{check_args_disabled}
\title{Check that disabled arguments are not specified}
\usage{
check_args_disabled(args_disabled)
}
\arguments{
\item{args_disabled}{String. One or more names of arguments of the function
applied within the factory-made function.}
}
\value{
No return value; might throw an error.
}
\description{
If the user of the function factory specified its \code{.args_disabled} argument,
\code{check_args_disabled()} enforces this ban.
}
\details{
More precisely, it throws an error if the user of the factory-made function
specified one or more arguments which the user of the function factory had
disabled via the latter's \code{.args_disabled} argument. The arguments would
otherwise be passed on to the function that is mapped within the factory-made
function.

on the use of the certain arguments of the function applied by the
factory-made function.
}
\examples{
check_args_disabled(c("disabled1", "disabled2"))
}
