% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sboost.R
\name{sboost}
\alias{sboost}
\title{sboost Learning Algorithm}
\usage{
sboost(features, outcomes, iterations = 1, positive = NULL, verbose = FALSE)
}
\arguments{
\item{features}{feature set data.frame.}

\item{outcomes}{outcomes corresponding to the features.}

\item{iterations}{number of boosts.}

\item{positive}{the positive outcome to test for; if NULL, the first outcome in
alphabetical (or numerical) order will be chosen.}

\item{verbose}{If true, progress bar will be displayed in console.}
}
\value{
An \emph{sboost_classifier} S3 object containing:
\describe{
  \item{\emph{classifier}}{\emph{stump} - the index of the decision stump\cr
    \emph{feature} - name of the column that this stump splits on.\cr
    \emph{vote} - the weight that this stump has on the final classifier.\cr
    \emph{orientation} - shows how outcomes are split. If \emph{feature} is numeric
      shows split orientation, if \emph{feature} value is less than \emph{split} then vote
      is cast in favor of left side outcome, otherwise the vote is cast for the
      right side outcome. If \emph{feature} is categorical, vote is
      cast for the left side outcome if \emph{feature} value is found in
      \emph{left_categories}, otherwise vote is cast for right side outcome.\cr
    \emph{split} - if \emph{feature} is numeric, the value where the decision stump
            splits the outcomes; otherwise, NA.\cr
    \emph{left_categories} - if \emph{feature} is categorical, shows the \emph{feature}
      values that sway the vote to the left side outcome on the \emph{orientation} split;
      otherwise, NA.}
  \item{\emph{outcomes}}{Shows which outcome was considered as positive and which negative.}
  \item{\emph{training}}{\emph{stumps} - how many decision stumps were trained.\cr
    \emph{features} - how many features the training set contained.\cr
    \emph{instances} - how many instances or rows the training set contained.\cr
    \emph{positive_prevalence} - what fraction of the training instances were positive.}
  \item{\emph{call}}{Shows the parameters that were used to build the classifier.}
}
}
\description{
A machine learning algorithm using AdaBoost on decision stumps.
}
\details{
Factors and characters are treated as categorical features.
Missing values are supported.

See \url{https://jadonwagstaff.github.io/projects/sboost.html} for a description
of the algorithm.

For original paper describing AdaBoost see:

Freund, Y., Schapire, R.E.: A decision-theoretic generalization of on-line
learning and an application to boosting. Journal of Computer and System Sciences
55(1), 119-139 (1997)
}
\examples{
# malware
malware_classifier <- sboost(malware[-1], malware[1], iterations = 5, positive = 1)
malware_classifier
malware_classifier$classifier

# mushrooms
mushroom_classifier <- sboost(mushrooms[-1], mushrooms[1], iterations = 5, positive = "p")
mushroom_classifier
mushroom_classifier$classifier
}
\seealso{
\code{\link{predict.sboost_classifier}} - to get predictions from the classifier.

  \code{\link{assess}} - to evaluate the performance of the classifier.

  \code{\link{validate}} - to perform cross validation for the classifier training.
}
