% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grainSimilarityMatrices.R
\name{grainSimilarity_align}
\alias{grainSimilarity_align}
\title{Grain Type similarity matrix for DTW alignments}
\usage{
grainSimilarity_align(triag = TRUE)
}
\arguments{
\item{triag}{Return a triangular matrix (TRUE, default) or a symmetric matrix (FALSE)}
}
\value{
data.frame, either triangular or symmetric
}
\description{
Get the relative similarity matrix of grain types as used for snow profile alignments. This similarity matrix
considers the formation and metamorphosis of grain types, as well as quirks of the SNOWPACK model. \cr
\link{grainSimilarity_evaluate} is an analogous matrix designed for assessing the similarity between two profiles, which
requires considering the resulting avalanche hazard implications of grain types. \cr
The domain is \verb{[0, 1]} --- \code{1} representing identical grain types. The column 'NA' can be used for unknown grain
types.
}
\examples{

## "similarity" matrix:
simMat <- grainSimilarity_align()
print(simMat)

## equivalent "distance" matrix:
distMat <- sim2dist(grainSimilarity_align())
print(distMat)

}
\seealso{
\link{grainSimilarity_evaluate}, \link{layerWeightingMat}
}
\author{
fherla
}
