% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience.R
\name{sc_left_join}
\alias{sc_left_join}
\title{Performs various checks after a left-join was performed}
\usage{
sc_left_join(joined, left, right, by, ..., find_nonunique_key = TRUE)
}
\arguments{
\item{joined}{the result of the left-join}

\item{left}{the left table used in the left-join}

\item{right}{the right table used in the left-join}

\item{by}{the variables used for the left-join}

\item{...}{further parameters that are passed to \link{add_sanity_check}.}

\item{find_nonunique_key}{if TRUE a sanity-check is performed
that finds keys (defined by \code{by}) that are non-unique.
However this can be a time-consuming step.}
}
\value{
list with two elements for the two sanity checks performed
  by this function. The structure of each element is as the
  return object of \link{add_sanity_check}.
}
\description{
One check is that no rows were duplicated during merge
and the other check is that no columns were duplicated
during merge.
}
\examples{
ab <- data.table::data.table(a = 1:4, b = letters[1:4])
abc <- data.table::data.table(a = c(1:4, 2), b = letters[1:5], c = rnorm(5))
j <- merge(x = ab, y = abc, by = "a")
dummy_call <- function() {
  sc_left_join(joined = j, left = ab, right = abc, by = "a",
    description = "Left join outcome to main population")
}
dummy_call()
get_sanity_checks()
}
