% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience.R
\name{sc_cols_non_NA}
\alias{sc_cols_non_NA}
\title{Checks that all elements from the specified columns are not NA}
\usage{
sc_cols_non_NA(object, cols = names(object), ..., unk_cols_callback = stop)
}
\arguments{
\item{object}{table with a columns specified by \code{cols}}

\item{cols}{vector of characters of columns that are checked for NAs}

\item{...}{further parameters that are passed to \link{add_sanity_check}.}

\item{unk_cols_callback}{user-defined function that is called if
some of the \code{cols} are not contained in the \code{object}.
This is helpful if an additional warning or error should be thrown
or maybe a log-entry should be created. Default is the function
\code{stop}}
}
\value{
a list where every element is an object returned by
  \link{add_sanity_check} for each column specified in \code{cols}
  that exists in \code{object}
}
\description{
Checks that all elements from the specified columns are not NA
}
\examples{
iris[c(1,3,5,7,9), 1] <- NA
dummy_call <- function(x) {
  sc_cols_non_NA(object = iris, description = "No NAs expected in iris")
}
dummy_call(x = iris)
get_sanity_checks()
}
