% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{psm}
\alias{psm}
\title{Compute the Posterior Pairwise Similarity for All Pairs of Items}
\usage{
psm(partitions)
}
\arguments{
\item{partitions}{A matrix, with each row a numeric vector cluster labels}
}
\value{
A symmetric matrix of pairwise similarities based on the partitions
  given.
}
\description{
Compute the Posterior Pairwise Similarity for All Pairs of Items
}
\examples{

# Neal (2000) model and data
nealData <- c(-1.48, -1.40, -1.16, -1.08, -1.02, 0.14, 0.51, 0.53, 0.78)
mkLogPosteriorPredictiveDensity <- function(data = nealData,
                                            sigma2 = 0.1^2,
                                            mu0 = 0,
                                            sigma02 = 1) {
  function(i, subset) {
    posteriorVariance <- 1 / ( 1/sigma02 + length(subset)/sigma2 )
    posteriorMean <- posteriorVariance * ( mu0/sigma02 + sum(data[subset])/sigma2 )
    posteriorPredictiveSD <- sqrt(posteriorVariance + sigma2)
    dnorm(data[i], posteriorMean, posteriorPredictiveSD, log=TRUE)
  }
}

logPostPredict <- mkLogPosteriorPredictiveDensity()

nSamples <- 500L
partitions <- matrix(0, nrow=nSamples, ncol=length(nealData))
for ( i in 2:nSamples ) {
  partitions[i,] <- nealAlgorithm3(partitions[i-1,], logPostPredict, mass = 1.0, nUpdates = 2)
}

psm(partitions)
}
