% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMfun.R
\name{report_CM}
\alias{report_CM}
\title{Conditioning model markdown report}
\usage{
report_CM(
  stanfit,
  year,
  cov1_names,
  cov_names,
  rs_names,
  name,
  filename = "CM",
  dir = tempdir(),
  open_file = TRUE,
  render_args = list(),
  ...
)
}
\arguments{
\item{stanfit}{Output from \code{\link[=sample_CM]{sample_CM()}}}

\item{year}{Optional vector of calendar years}

\item{cov1_names}{Optional character vector for names of covariates that predict age-1 natural mortality}

\item{cov_names}{Optional character vector for names of covariates that predict age-2+ natural mortality}

\item{rs_names}{Optional character vector for names of hatchery release strategies}

\item{name}{Optional character string for the model name to include in the report, e.g., model run number}

\item{filename}{Character string for the name of the markdown and HTML files}

\item{dir}{The directory in which the markdown and HTML files will be saved.}

\item{open_file}{Logical, whether the HTML document is opened after it is rendered}

\item{render_args}{List of arguments to pass to \code{\link[rmarkdown:render]{rmarkdown::render()}}}

\item{...}{Additional arguments (not used)}
}
\value{
Returns invisibly the output of \code{\link[rmarkdown:render]{rmarkdown::render()}}, typically the path of the output file
}
\description{
Generate a markdown report to plot time series and MCMC posteriors of estimates from the conditioning model
}
\details{
Report excludes MCMC values from warmup iterations
}
\seealso{
\code{\link[=fit_CM]{fit_CM()}}
}
