% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define-SOM.R
\docType{class}
\name{SHist-class}
\alias{SHist-class}
\title{Class \code{"SHist"}}
\description{
Stores the outputs from the historical reconstruction of salmon operating models.
}
\section{Slots}{

\describe{
\item{\code{Name}}{Character. Identifying name}

\item{\code{nyears}}{Integer. The number of historical years}

\item{\code{nsim}}{Integer. The number of simulations}

\item{\code{nstocks}}{Integer. The number of stocks}

\item{\code{Snames}}{Character. Stock names}

\item{\code{Egg_NOS}}{Array \verb{[nsim, nstocks, nyears]}. Spawning output, i.e., egg production, of natural origin spawners.}

\item{\code{Egg_HOS}}{Array \verb{[nsim, nstocks, nyears]}. Spawning output of hatchery origin spawners.}

\item{\code{Smolt}}{Array \verb{[nsim, nstocks, nyears]}. Natural smolt production (sum of offspring of natural and hatchery spawners).}

\item{\code{Smolt_Rel}}{Array \verb{[nsim, nstocks, proyears]}. Smolts that are offspring of broodtake, i.e., hatchery releases.}

\item{\code{Njuv_NOS}}{Array \verb{[nsim, nstocks, nage, nyears]}. Abundance of juvenile natural origin fish at the beginning of the year.}

\item{\code{Njuv_HOS}}{Array \verb{[nsim, nstocks, nage, nyears]}. Abundance of juvenile hatchery origin fish at the beginning of the year.}

\item{\code{Return_NOS}}{Array \verb{[nsim, nstocks, nage, nyears]}. Mature fish that will be natural origin spawners.}

\item{\code{Return_HOS}}{Array \verb{[nsim, nstocks, nage, nyears]}. Mature fish that will be hatchery origin spawners.}

\item{\code{Escapement_NOS}}{Array \verb{[nsim, nstocks, nage, nyears]}. The escapement of mature fish that will be natural origin spawners.}

\item{\code{Escapement_HOS}}{Array \verb{[nsim, nstocks, nage, nyears]}. The escapement of mature fish that will be hatchery origin spawners.}

\item{\code{NOS}}{Array \verb{[nsim, nstocks, proyears]}. Natural origin spawners.}

\item{\code{HOS}}{Array \verb{[nsim, nstocks, proyears]}. Hatchery origin spawners.}

\item{\code{HOS_effective}}{Array \verb{[nsim, nstocks, proyears]}. Hatchery origin spawners discounted by \code{gamma}.}

\item{\code{KPT_NOS}}{Array \verb{[nsim, nstocks, proyears]}. Pre-terminal fishery kept catch of natural origin spawners.}

\item{\code{KT_NOS}}{Array \verb{[nsim, nstocks, proyears]}. Terminal fishery kept catch of natural origin spawners.}

\item{\code{KPT_HOS}}{Array \verb{[nsim, nstocks, proyears]}. Pre-terminal fishery kept catch of hatchery origin spawners.}

\item{\code{KT_HOS}}{Array \verb{[nsim, nstocks, proyears]}. Terminal fishery kept catch of hatchery origin spawners.}

\item{\code{DPT_NOS}}{Array \verb{[nsim, nstocks, proyears]}. Pre-terminal fishery released catch (live and dead) of natural origin spawners.}

\item{\code{DT_NOS}}{Array \verb{[nsim, nstocks, proyears]}. Terminal fishery released catch (live and dead) of natural origin spawners.}

\item{\code{DPT_HOS}}{Array \verb{[nsim, nstocks, proyears]}. Pre-terminal fishery released catch (live and dead) of hatchery origin spawners.}

\item{\code{DT_HOS}}{Array \verb{[nsim, nstocks, proyears]}. Terminal fishery released catch (live and dead) hatchery origin spawners.}

\item{\code{UPT_NOS}}{Array \verb{[nsim, nstocks, proyears]}. Pre-terminal fishery harvest rate (from kept catch) of natural origin spawners.}

\item{\code{UT_NOS}}{Array \verb{[nsim, nstocks, proyears]}. Terminal fishery harvest rate of natural origin spawners.}

\item{\code{UPT_HOS}}{Array \verb{[nsim, nstocks, proyears]}. Pre-terminal fishery harvest rate of hatchery origin spawners.}

\item{\code{UT_HOS}}{Array \verb{[nsim, nstocks, proyears]}. Terminal fishery harvest rate of hatchery origin spawners.}

\item{\code{ExPT_NOS}}{Array \verb{[nsim, nstocks, proyears]}. Pre-terminal fishery exploitation rate (from kept catch and dead releases) of natural origin spawners.}

\item{\code{ExT_NOS}}{Array \verb{[nsim, nstocks, proyears]}. Terminal fishery exploitation rate of natural origin spawners.}

\item{\code{ExPT_HOS}}{Array \verb{[nsim, nstocks, proyears]}. Pre-terminal fishery exploitation rate of hatchery origin spawners.}

\item{\code{ExT_HOS}}{Array \verb{[nsim, nstocks, proyears]}. Terminal fishery exploitation rate of hatchery origin spawners.}

\item{\code{Misc}}{List. Miscellaneous output}
}}

\examples{
showClass("SHist")
}
\keyword{classes}
