% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{generateSurvData}
\alias{generateSurvData}
\title{Generate Survival Data which Can Be Analysed With the `survival` Package}
\usage{
generateSurvData(
  nP,
  nT,
  alpha = 1,
  lambdaP,
  lambdaT,
  seed = NULL,
  nDigits = 0,
  startTime = 1,
  endTime = 180,
  orderTime = TRUE,
  competeRatio = 0
)
}
\arguments{
\item{nP}{integer > 0 representing the number of of patients in the placebo group.}

\item{nT}{integer > 0 representing the number of of patients in the treatment group.}

\item{alpha}{numeric > 0, representing the shape parameter of the Weibull distribution.
If alpha=1, then data are generated from the exponential, i.e., constant hazard. For alpha > 1
the hazard increases, if alpha < 1, the hazard decreases.}

\item{lambdaP}{The (relative) hazard of the placebo group.}

\item{lambdaT}{The (relative) hazard of the treatment group.}

\item{seed}{A seed number.}

\item{nDigits}{numeric, the number of digits to round of the random time to}

\item{startTime}{numeric, adds this to the random times. Default 1, so the startTime is not 0, which
is the start time of \code{\link[stats]{rweibull}}.}

\item{endTime}{The endtime of the experiment.}

\item{orderTime}{logical, if \code{TRUE} then put the data set in increasing order}

\item{competeRatio}{The ratio of the data that is due to competing risk.}
}
\value{
A data set with time, status and group.
}
\description{
Generate Survival Data which Can Be Analysed With the `survival` Package
}
\examples{
generateSurvData(800, 800, alpha=1, lambdaP=0.008, lambdaT=0.008/2)
}
