% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rwisp.r
\name{wispcalc}
\alias{wispcalc}
\title{Integrated Simple Weighted Sum Product Method - WISP}
\usage{
wispcalc(data, alternatives, optimizations, weights)
}
\arguments{
\item{data}{A numeric data matrix, columns are the criteria, rows are the alternatives}

\item{alternatives}{A character vector with the identification of alternatives}

\item{optimizations}{A character vector with definition of minimization or maximization for each criterion, expected 'min' or 'max' only}

\item{weights}{A numeric vector with the criteria weights, the sum of all must be 1}
}
\value{
list with 3 matrix, ui = ranking and the global ui, normalizedData = normalized data, utilities = utility values
}
\description{
Implementation of An Integrated Simple Weighted Sum Product Method - WISP
More information about the method at https://doi.org/10.1109/TEM.2021.3075783
More information about the implementation at https://github.com/dioubernardo/rwisp/blob/main/README.md
}
\examples{
alternatives <- c("A1", "A2", "A3", "A4", "A5")
optimizations <- c("max", "min", "max", "max", "min", "max", "min", "max", "min", "max")
weights <- c(0.07, 0.07, 0.07, 0.14, 0.2, 0.08, 0.12, 0.125, 0.05, 0.075)
data <- matrix(c(
  c(3, 4, 6, 5, 2), # criterion 1 values
  c(7, 6, 4, 6, 8), # criterion 2 values
  c(4, 5, 5, 6, 3), # criterion 3 values
  c(4, 5, 6, 5, 4), # criterion 4 values
  c(6, 5, 4, 3, 6), # criterion 5 values
  c(4, 5, 5, 6, 3), # criterion 6 values
  c(6, 5, 5, 4, 6), # criterion 7 values
  c(8, 8, 9, 7, 7), # criterion 8 values
  c(5, 6, 7, 8, 7), # criterion 9 values
  c(8, 9, 9, 9, 8) # criterion 10 values
), nrow=5, ncol=10)
result <- wispcalc(data, alternatives, optimizations, weights)
}
