% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANOVA_DDCt.R
\name{ANOVA_DDCt}
\alias{ANOVA_DDCt}
\title{Delta Delta Ct ANOVA analysis with optional model specification}
\usage{
ANOVA_DDCt(
  x,
  numOfFactors,
  numberOfrefGenes,
  mainFactor.column,
  block,
  mainFactor.level.order = NULL,
  p.adj = "none",
  analyseAllTarget = TRUE,
  model = NULL,
  set_missing_target_Ct_to_40 = FALSE
)
}
\arguments{
\item{x}{The input data frame containing experimental design columns, replicates (integer), target gene
E/Ct column pairs, and reference gene E/Ct column pairs. Reference gene
columns must be located at the right end of the data frame. See "Input data 
structure" in vignettes for details about data structure.}

\item{numOfFactors}{Integer. Number of experimental factor columns
(excluding \code{rep} and optional \code{block}).}

\item{numberOfrefGenes}{Integer. Number of reference genes.}

\item{mainFactor.column}{Integer. Column index of the factor for which the relative expression analysis is applied.}

\item{block}{Character. Block column name or \code{NULL}. 
When a qPCR experiment is done in multiple qPCR plates, 
variation resulting from the plates may interfere with the actual amount of 
gene expression. One solution is to conduct each plate as a randomized block 
so that at least one replicate of each treatment and control is present 
on a plate. Block effect is usually considered as random and its interaction 
with any main effect is not considered.}

\item{mainFactor.level.order}{Optional character vector specifying the order of levels for the main factor.
If \code{NULL}, the first observed level is used as the calibrator.
If provided, the first element of the vector is used as the calibrator level.}

\item{p.adj}{Method for p-value adjustment. See \code{\link[stats]{p.adjust}}.}

\item{analyseAllTarget}{Logical or character.
If \code{TRUE} (default), all target genes are analysed.
Alternatively, a character vector specifying the names (names of their Efficiency columns) of target genes
to be analysed.}

\item{model}{Optional model formula. If provided, this overrides the automatic formula (CRD or RCBD 
based on \code{block} and \code{numOfFactors}). The formula uses 
\code{wDCt} as the response variable. 
For mixed models, random effects can be defined using \code{lmer} syntax 
(e.g., \code{"wDCt ~ Treatment + (1|Block)"}). When using \code{model}, 
the \code{block} and \code{numOfFactors} arguments are ignored for model 
specification, but still used for data structure identification.
  
for fixed effects only, the \code{"lm"} (ordinary least squares) is used. 
\code{"lmer"} is used for mixed effects models 
(requires the \code{lmerTest} package). If a custom formula is provided with 
random effects, the function will use \code{lmerTest::lmer()}; otherwise 
it will use \code{stats::lm()}. Note that \code{emmeans} supports both 
model types and will use appropriate degrees of freedom methods (Satterthwaite by default).}

\item{set_missing_target_Ct_to_40}{If \code{TRUE}, missing target gene Ct values become 40; if \code{FALSE} (default), they become NA.}
}
\value{
An object containing expression table, lm model, residuals, raw data and ANOVA table for each gene:
\describe{  
\item{ddCt expression table along with per-gene statistical comparison outputs}{\code{object$relativeExpression}}
\item{ANOVA table}{\code{object$perGene$gene_name$ANOVA_table}}
\item{lm ANOVA}{\code{object$perGene$gene_name$lm}}
\item{lm_formula}{\code{object$perGene$gene_name$lm_formula}}
\item{Residuals}{\code{resid(object$perGene$gene_name$lm)}}
}
}
\description{
Apply Delta Delta Ct (ddCt) analysis to each target gene
and performs per-gene statistical analysis.
}
\details{
ddCt analysis of variance (ANOVA) is performed for 
the \code{mainFactor.column} based on a full model factorial 
experiment by default. However, if \code{ANCOVA_DDCt} function is used, 
analysis of covariance is performed for the levels of the \code{mainFactor.column} and the other factors are 
treated as covariates. if the interaction between the main factor and the covariate is significant, ANCOVA is not appropriate.

All the functions for relative expression analysis (including \code{TTEST_DDCt()}, 
\code{WILCOX_DDCt()}, \code{ANOVA_DDCt()}, and \code{ANOVA_DCt()}) return the 
relative expression table which include fold change and corresponding 
statistics. The output of \code{ANOVA_DDCt()}, 
and \code{ANOVA_DCt()} also include lm models, residuals, raw data and ANOVA table 
for each gene. 

The expression table returned by \code{TTEST_DDCt()}, 
\code{WILCOX_DDCt()}, and \code{ANOVA_DDCt()} functions 
include these columns: gene (name of target genes), 
contrast (calibrator level and contrasts for which the relative expression is computed), 
ddCt (mean of weighted delta delta Ct values), RE (relative expression or 
fold change = 2^-ddCt),  log2FC (log(2) of relative expression or fold change), 
pvalue, sig (per-gene significance), LCL (95\% lower confidence level), UCL (95\% upper confidence level),
se (standard error of mean calculated from the weighted delta Ct values of each of the main factor levels),
Lower.se.RE (The lower limit error bar for RE which is 2^(log2(RE) - se)), 
Upper.se.RE (The upper limit error bar for RE which is 2^(log2(RE) + se)),
Lower.se.log2FC (The lower limit error bar for log2 RE), and 
Upper.se.log2FC (The upper limit error bar for log2 RE)
}
\examples{
data1 <- read.csv(system.file("extdata", "data_2factorBlock3ref.csv", package = "rtpcr"))
ANOVA_DDCt(x = data1,
           numOfFactors = 2,
           numberOfrefGenes = 3,
           block = "block",
           mainFactor.column = 2,
           p.adj = "none")
           
data2 <- read.csv(system.file("extdata", "data_1factor_one_ref.csv", package = "rtpcr"))          
ANOVA_DDCt(x = data2,
           numOfFactors = 1,
           numberOfrefGenes = 1,
           block = NULL,
           mainFactor.column = 1,
           p.adj = "none")
  
# Repeated measure analysis         
a <- ANOVA_DDCt(data_repeated_measure_1,
           numOfFactors = 1,
           numberOfrefGenes = 1,
           block = NULL,
           mainFactor.column = 1,
           p.adj = "none", model = wDCt ~ time + (1 | id))

a$perGene$Target$ANOVA_table


# Repeated measure analysis: split-plot in time
a <- ANOVA_DDCt(data_repeated_measure_2,
           numOfFactors = 2, numberOfrefGenes = 1,
           mainFactor.column = 2, block = NULL,
           model = wDCt ~ treatment * time + (1 | id))
           
}
\references{
LivakKJ, Schmittgen TD (2001).
Analysis of Relative Gene Expression Data Using Real-Time Quantitative PCR
and the Double Delta CT Method.
\emph{Methods}, 25(4), 402–408.
doi:10.1006/meth.2001.1262

Ganger MT, Dietz GD, and Ewing SJ (2017).
A common base method for analysis of qPCR data and the application of
simple blocking in qPCR experiments.
\emph{BMC Bioinformatics}, 18, 1–11.

Taylor SC, Nadeau K, Abbasi M, Lachance C, Nguyen M, Fenrich, J. (2019). 
The ultimate qPCR experiment: producing publication quality, reproducible 
data the first time. \emph{Trends in Biotechnology}, 37, 761-774. 

Yuan JS, Reed A, Chen F, Stewart N (2006).
Statistical Analysis of Real-Time PCR Data.
\emph{BMC Bioinformatics}, 7, 85.
}
