% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtmsMeasurement.R
\name{measureSampleSet}
\alias{measureSampleSet}
\title{Measure peaks and samples in an RTMS sample set}
\usage{
measureSampleSet(sampleset, measure = "PeakIntensity")
}
\arguments{
\item{sampleset}{An object of class \code{rtmsSampleSet}}

\item{measure}{A character vector of named measurements, or a list of
custom measurement functions.  Supported measurement names are
"PeakIntensity", which takes the total of any local maxima within the peak
width, "PeakArea", which takes the area under the intensity curve within the
peak width, and "NumPeaks", which counts the local maxima in the peak window.
If \code{measure} is a list of functions, each function must take an object of
class \code{rtmsSubsample}, and return a single numeric value.  If the functions
are named, those names will be returned in the "measure" column of the
resulting data frame; otherwise they will be identified as "Measure1",
"Measure2", etc.}
}
\value{
A data frame with one row for each sample, peak, and measurement.
The data.frame will have a character column named "sample", containing either
the name of the sample (if the samples in \code{sampleset} are named) or the
index of the sample if they are not (but it will always be a character
column); a column named "peakName" with the name of the relevant peak  (if
the "peaks" attribute of \code{sampleset} is a named list); a column named
"peakValue" containing the m/z value at the center of the relevant peak; a
column named "measure" containing the name of the relevant measure; and a
column named "value" containing the numeric value of the particular measure
for that sample and peak.
}
\description{
\code{measureSampleSet()} extracts one or more measurements for every peak in
every sample in an RTMS sample set object (of class \code{rtmsSampleSet}).
}
\examples{
peaks <- rtmsPeakList(c(1516.83,1530.84),peakWidth=0.2,windowWidth = c(5,10))
names(peaks) <- c("Product","Substrate")
sample <- getSample(exampleSpectrum,peaks)
sampleSet <- rep(sample,3)
names(sampleSet) <- c("A","B","C")

measures <- measureSampleSet(sampleSet)
}
