/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.analysis.strata;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.DataView;
import org.vikamine.kernel.data.NominalAttribute;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.subgroup.Options;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.analysis.strata.CFStratifiedSGHolder;
import org.vikamine.kernel.subgroup.selectors.DefaultSGSelector;
import org.vikamine.kernel.subgroup.selectors.NegatedSGSelector;
import org.vikamine.kernel.subgroup.selectors.SGNominalSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.subgroup.target.BooleanTarget;
import org.vikamine.kernel.subgroup.target.SGTarget;

public class CFStratifiedStatisticsCreator {
    private static CFStratifiedStatisticsCreator instance = new CFStratifiedStatisticsCreator();

    private CFStratifiedStatisticsCreator() {
    }

    public static CFStratifiedStatisticsCreator getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Instance should have been eagerly created!");
        }
        return instance;
    }

    public CFStratifiedStatistics createCFStratifiedStatistics(SG sg, NominalAttribute stratifyingAttribute) {
        CFStratifiedStatistics stats = new CFStratifiedStatistics(sg, stratifyingAttribute);
        stats.strataValsForSGInPop = new double[stratifyingAttribute.getValuesCount()];
        stats.strataValsForTVInPop = new double[stratifyingAttribute.getValuesCount()];
        stats.strataValsForTVInSG = new double[stratifyingAttribute.getValuesCount()];
        stats.strataValsForTVInComplementaryPop = new double[stratifyingAttribute.getValuesCount()];
        int[] populationCountsInStrata = new int[stratifyingAttribute.getValuesCount()];
        int[] subgroupCountsInStrata = new int[stratifyingAttribute.getValuesCount()];
        int[] fnAndTn = new int[stratifyingAttribute.getValuesCount()];
        SGTarget target = sg.getTarget();
        if (target == null || target instanceof BooleanTarget) {
            BooleanTarget tVar = (BooleanTarget)target;
            List<SGSelector> populationRangesSelectors = sg.getPopulation().populationRangesSelectors();
            if (sg.getStatistics().getOptions().getBooleanAttributeOption(stratifyingAttribute, Options.TREAT_MISSING_NOT_AS_DEFINED_VALUE)) {
                populationRangesSelectors.add(new NegatedSGSelector(new DefaultSGSelector((Attribute)stratifyingAttribute, Value.missingValue(stratifyingAttribute))));
            }
            DataView strataPopulation = sg.getPopulation().createPopulation(populationRangesSelectors);
            Iterator<DataRecord> iter = strataPopulation.instanceIterator();
            while (iter.hasNext()) {
                int stratValIndex;
                DataRecord inst = iter.next();
                if (!sg.getStatistics().isInstanceDefinedForSubgroupVars(inst) || inst.isMissing(stratifyingAttribute)) continue;
                int n = stratValIndex = (int)inst.getValue(stratifyingAttribute);
                populationCountsInStrata[n] = populationCountsInStrata[n] + 1;
                if (sg.getSGDescription().isMatching(inst)) {
                    int n2 = stratValIndex;
                    subgroupCountsInStrata[n2] = subgroupCountsInStrata[n2] + 1;
                    double[] dArray = stats.strataValsForSGInPop;
                    int n3 = stratValIndex;
                    dArray[n3] = dArray[n3] + 1.0;
                    if (tVar == null || !tVar.isPositive(inst)) continue;
                    double[] dArray2 = stats.strataValsForTVInSG;
                    int n4 = stratValIndex;
                    dArray2[n4] = dArray2[n4] + 1.0;
                    double[] dArray3 = stats.strataValsForTVInPop;
                    int n5 = stratValIndex;
                    dArray3[n5] = dArray3[n5] + 1.0;
                    continue;
                }
                if (tVar != null && tVar.isPositive(inst)) {
                    double[] dArray = stats.strataValsForTVInPop;
                    int n6 = stratValIndex;
                    dArray[n6] = dArray[n6] + 1.0;
                    double[] dArray4 = stats.strataValsForTVInComplementaryPop;
                    int n7 = stratValIndex;
                    dArray4[n7] = dArray4[n7] + 1.0;
                    int n8 = stratValIndex;
                    fnAndTn[n8] = fnAndTn[n8] + 1;
                    continue;
                }
                if (tVar == null || tVar.isPositive(inst)) continue;
                int n9 = stratValIndex;
                fnAndTn[n9] = fnAndTn[n9] + 1;
            }
            int i = 0;
            while (i < stratifyingAttribute.getValuesCount()) {
                double[] dArray = stats.strataValsForTVInSG;
                int n = i;
                dArray[n] = dArray[n] / (double)subgroupCountsInStrata[i];
                double[] dArray5 = stats.strataValsForSGInPop;
                int n10 = i;
                dArray5[n10] = dArray5[n10] / (double)populationCountsInStrata[i];
                double[] dArray6 = stats.strataValsForTVInPop;
                int n11 = i;
                dArray6[n11] = dArray6[n11] / (double)populationCountsInStrata[i];
                double[] dArray7 = stats.strataValsForTVInComplementaryPop;
                int n12 = i;
                dArray7[n12] = dArray7[n12] / (double)fnAndTn[i];
                ++i;
            }
        } else {
            throw new RuntimeException("Only boolean targets supported so far!");
        }
        return stats;
    }

    List createStratifiedSGHolders(SG sg, NominalAttribute strataAttribute) {
        LinkedList<CFStratifiedSGHolder> strataSubgroupHolders = new LinkedList<CFStratifiedSGHolder>();
        LinkedList<SGSelector> basePopulationSelectors = new LinkedList<SGSelector>(sg.getPopulation().populationRangesSelectors());
        CFStratifiedSGHolder h = this.createStratifiedSGHolderForTotalSG(sg, strataAttribute, basePopulationSelectors);
        strataSubgroupHolders.add(h);
        if (strataAttribute.isNominal()) {
            Iterator<Value> iter = strataAttribute.allValuesIterator();
            while (iter.hasNext()) {
                Value val = iter.next();
                DefaultSGSelector sel = new DefaultSGSelector((Attribute)strataAttribute, val);
                SG strataSubgroup = this.createStratumSubgroup(sg, basePopulationSelectors, sel);
                strataSubgroupHolders.add(new CFStratifiedSGHolder(strataSubgroup, sel));
            }
            if (sg.getStatistics().getOptions().getBooleanAttributeOption(strataAttribute, Options.TREAT_MISSING_NOT_AS_DEFINED_VALUE)) {
                DefaultSGSelector missingSel = new DefaultSGSelector((Attribute)strataAttribute, Value.missingValue(strataAttribute));
                SG strataSubgroup = this.createStratumSubgroup(sg, basePopulationSelectors, missingSel);
                strataSubgroupHolders.add(new CFStratifiedSGHolder(strataSubgroup, missingSel));
            }
            return strataSubgroupHolders;
        }
        return Collections.EMPTY_LIST;
    }

    private SG createStratumSubgroup(SG sg, List basePopulationSelectors, SGNominalSelector sel) {
        SG strataSubgroup = (SG)sg.clone();
        LinkedList<SGSelector> newSelectors = new LinkedList<SGSelector>(basePopulationSelectors);
        newSelectors.add(sel);
        DataView strataPopulation = sg.getPopulation().createPopulation(newSelectors);
        strataSubgroup.setPopulation(strataPopulation);
        strataSubgroup.createStatistics(sg.getStatistics().getOptions());
        return strataSubgroup;
    }

    private CFStratifiedSGHolder createStratifiedSGHolderForTotalSG(SG sg, Attribute strataAttribute, List basePopulationSelectors) {
        SG clonedSubgroup = (SG)sg.clone();
        LinkedList<SGSelector> selectors = new LinkedList<SGSelector>(basePopulationSelectors);
        NegatedSGSelector totalSel = new NegatedSGSelector(new DefaultSGSelector(strataAttribute, Value.missingValue(strataAttribute)));
        if (sg.getStatistics().getOptions().getBooleanAttributeOption(strataAttribute, Options.TREAT_MISSING_NOT_AS_DEFINED_VALUE)) {
            selectors.add(totalSel);
        }
        DataView population = sg.getPopulation().createPopulation(selectors);
        clonedSubgroup.setPopulation(population);
        clonedSubgroup.createStatistics(sg.getStatistics().getOptions());
        CFStratifiedSGHolder h = new CFStratifiedSGHolder(clonedSubgroup, totalSel);
        return h;
    }

    public static class CFStratifiedStatistics {
        private SG sg;
        private NominalAttribute stratifyingAttribute;
        private double[] strataValsForTVInSG;
        private double[] strataValsForTVInPop;
        private double[] strataValsForSGInPop;
        private double[] strataValsForTVInComplementaryPop;

        public CFStratifiedStatistics(SG sg, NominalAttribute stratifyingAttribute) {
            this.sg = sg;
            this.stratifyingAttribute = stratifyingAttribute;
        }

        public SG getSg() {
            return this.sg;
        }

        public double[] getStrataValsForSGInPop() {
            return this.strataValsForSGInPop;
        }

        public double[] getStrataValsForTVInPop() {
            return this.strataValsForTVInPop;
        }

        public double[] getStrataValsForTVInSG() {
            return this.strataValsForTVInSG;
        }

        public double[] getStrataValsForTVInComplementaryPop() {
            return this.strataValsForTVInComplementaryPop;
        }

        public NominalAttribute getStratifyingAttribute() {
            return this.stratifyingAttribute;
        }

        public String verbalize() {
            StringBuffer buffy = new StringBuffer();
            buffy.append("TV " + (this.sg.getTarget() != null ? this.sg.getTarget().getDescription() : "None") + "\n");
            buffy.append("SG " + SG.verbalizeSGAsPrologLikeRule(this.sg) + "\n");
            buffy.append("StratVar " + this.stratifyingAttribute.getId() + "\n\n");
            buffy.append("\tPPV(Pop->TV)%\tPPV(SG->TV)%\tPPV(Pop->SG)%\ttPPV(ComplementaryPop->TV)%\n");
            int i = 0;
            Iterator<Value> iter = this.stratifyingAttribute.allValuesIterator();
            while (iter.hasNext()) {
                Value val = iter.next();
                buffy.append(String.valueOf(val.getDescription()) + "\t");
                buffy.append(String.valueOf(this.strataValsForTVInPop[i]) + "\t" + this.strataValsForTVInSG[i] + "\t" + this.strataValsForSGInPop[i] + "\t" + this.strataValsForTVInComplementaryPop[i] + "\n");
                ++i;
            }
            return buffy.toString();
        }
    }
}

