% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.summary.multisimsum.R
\name{print.summary.multisimsum}
\alias{print.summary.multisimsum}
\title{print.summary.multisimsum}
\usage{
\method{print}{summary.multisimsum}(x, digits = 4, mcse = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{summary.multisimsum}.}

\item{digits}{Number of significant digits used for printing.
Defaults to 4.}

\item{mcse}{Should Monte Carlo standard errors be reported?
If \code{mcse = FALSE}, confidence intervals based on Monte Carlo standard errors will be reported instead, see \code{\link[=summary.multisimsum]{summary.multisimsum()}}.
If a \code{NULL} value is passed, only point estimates are printed regardless of whether Monte Carlo standard errors were computed or not.
Defaults to \code{TRUE}.}

\item{...}{Ignored.}
}
\description{
Print method for \code{summary.multisimsum} objects
}
\examples{
data(frailty)
ms <- multisimsum(
  data = frailty, par = "par", true = c(
    trt = -0.50,
    fv = 0.75
  ), estvarname = "b", se = "se", methodvar = "model",
  by = "fv_dist"
)
sms <- summary(ms, stats = c("bias", "cover", "mse"))
sms

# Printing less significant digits:
print(sms, digits = 3)

# Printing confidence intervals:
print(sms, digits = 3, mcse = FALSE)

# Printing values only:
print(sms, mcse = NULL)
}
