% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcov.R
\name{qcov}
\alias{qcov}
\title{Approximate Covariance Matrix Estimation for Vectors of Quantile Estimators}
\usage{
qcov(
  x,
  u,
  method = "qor",
  FUN = qor.ln,
  quantile.type = 8,
  bw.correct = TRUE,
  ...
)
}
\arguments{
\item{x}{a numeric vector of data values.}

\item{u}{a numeric vector of probability values in the interval (0,1) specifying the quantiles to be estimated. Note that u must include numeric values between, and not including, 0 and 1 and missing values are not allowed.}

\item{method}{approach use to estimate the quantile density function. Either "qor" or "density".}

\item{FUN}{QOR function for the log-normal}

\item{quantile.type}{argument for the quantile function.  Default is set to 8 so that output is consistent with default quantile function use and other functions such as IQR (see help file for \code{quantile()}
for more details)}

\item{bw.correct}{replace bw by the values of v when v<=bw (see Prendergast & Staudte (2016b) for more details)}

\item{...}{additional arguments to be passed to function density when method = “density” is used.}
}
\value{
a covariance matrix consisting of variances (on the diagonal) for quantile estimates and covariances (off-diagonal) between different quantile estimates
}
\description{
compute a covariance matrix consisting of variances (on the diagonal) for quantile estimates and covariances (off-diagonal) between different quantile estimates
}
\details{
This function computes a covariance matrix for a vector of quantile estimators.
This is done via estimating the inverted density function evaluated at the respective quantiles.
The default for this is to use the quantile optimality ratio (QOR) approach (Prendergast & Staudte, 2016) which computes an optimal bandwidth.
Alternatively, using \code{method = "density"} will use the generic density function to estimate the density.
The estimated variances and covariance requires estimation of the probability density function.
If \code{method = "density"}, then the function density is used to do this.  If needed, additional arguments
can be passed to density (see ?density for details on possible additional arguments).
}
\examples{
# Create some data
set.seed(1234)
x <- rnorm(100)

# Compute the variance-covariance matrix for sample quartiles.
qcov(x, c(0.25, 0.5, 0.75))
}
\references{
Prendergast, L. A., & Staudte, R. G. (2016). Exploiting the quantile optimality ratio in finding confidence intervals for quantiles. Stat, 5(1), 70-81

Prendergast, L. A., Dedduwakumara, D.S. & Staudte, R.G. (2024) rquest: An R package for hypothesis tests and confidence intervals
for quantiles and summary measures based on quantiles, preprint, pages 1-13
}
