% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof.rpm.R
\name{gof}
\alias{gof}
\alias{gof.default}
\alias{gof.rpm}
\alias{plot.gofrpm}
\title{Calculate goodness-of-fit statistics for Revealed Preference Matchings Model based on observed data}
\usage{
gof(object, ...)

\method{gof}{rpm}(
  object,
  ...,
  empirical_p = TRUE,
  compare_sim = "sim-est",
  control = object$control,
  reboot = FALSE,
  verbose = FALSE
)

\method{plot}{gofrpm}(x, ..., cex.axis = 0.7, main = "Goodness-of-fit diagnostics")
}
\arguments{
\item{object}{list; an object of class\code{rpm} that is typically the result of a call to \code{rpm()}.}

\item{\dots}{Additional arguments, to be passed to lower-level functions.}

\item{empirical_p}{logical; (Optional) If TRUE the function returns the empirical p-value of the sample
statistic based on \code{nsim} simulations}

\item{compare_sim}{string; describes which two objects are compared to compute simulated goodness-of-fit
statistics; valid values are \code{"sim-est"}: compares the marginal distribution of pairings in a
simulated sample to the \code{rpm} model estimate of the marginal distribution based on that same simulated sample;
\code{mod-est}: compares the marginal distribution of pairings in a
simulated sample to the \code{rpm} model estimate used to generate the sample}

\item{control}{A list of control parameters for algorithm tuning. Constructed using
\code{\link{control.rpm}}, which should be consulted for specifics.}

\item{reboot}{logical; if this is \code{TRUE}, the program will rerun the bootstrap at the coefficient values, rather than 
expect the object to contain a \code{bs.results} component with the bootstrap results run at the solution values.
The latter is the default for \code{rpm} fits.}

\item{verbose}{logical; if this is \code{TRUE}, the program will print out
additional information, including data summary statistics.}

\item{x}{a list, usually an object of class gofrpm}

\item{cex.axis}{the magnification of the text used in axis notation;}

\item{main}{Title for the goodness-of-fit plots.}
}
\value{
\code{\link{gof.rpm}} returns a list consisting of the following elements:
\item{observed_pmf}{numeric matrix giving observed probability mass distribution over different household types}
\item{model_pmf}{numeric matrix giving expected probability mass distribution from \code{rpm} model}
\item{obs_chi_sq}{the count-based observed chi-square statistic comparing marginal distributions of the population
the data and the model estimate}
\item{obs_chi_sq_cell}{the contribution to the observed chi-squared statistic by household type}
\item{obs_kl}{the Kullback-Leibler (KL) divergence computed by comparing the observed marginal distributions to the
expected marginal distribution based on the \code{rpm} model estimate}
\item{obs_kl_cell}{the contribution to the observed KL divergence by household type}
\item{empirical_p_chi_sq}{the proportion of simulated chi-square statistics that are greater than
or equal to the observed chi-square statistic}
\item{empirical_p_kl}{the proportion of simulated KL divergences that are greater than
or equal to the observed KL divergence}
\item{chi_sq_simulated}{vector of size \code{nsim} storing all simulated chi-square statistics}
\item{kl_simulated}{vector of size \code{nsim} storing all simulated KL divergences}
\item{chi_sq_cell_mean}{Mean contributions of each household type to the simulated chi_sq statistic}
\item{chi_sq_cell_sd}{Standard deviation of the contributions of each household type to the simulated chi_sq statistics}
\item{chi_sq_cell_median}{Median contributions of each household type to the simulated chi_sq statistic}
\item{chi_sq_cell_iqr}{Interquartile range of the contributions of each household type to the simulated chi_sq statistics}
\item{kl_cell_mean}{Mean contributions of each household type to the simulated KL divergences}
\item{kl_cell_sd}{Standard deviation of the contributions of each household type to the simulated KL divergencesc}
\item{kl_cell_median}{Median contributions of each household type to the simulated KL divergences}
\item{kl_cell_iqr}{Interquartile range of the contributions of each household type to the simulated KL divergences}
}
\description{
\code{\link{gof.rpm}} ...
It is typically based on the estimate from a \code{rpm()} call.
}
\details{
The function \code{\link{rpm}} is used to fit a revealed preference model
for men and women of certain
characteristics (or shared characteristics) of people of the opposite sex.
The model assumes a one-to-one stable matching using an observed set of
matchings and a set of (possibly dyadic) covariates to 
estimate the parameters for
linear equations of utilities.
It does this using an large-population likelihood based on ideas from Dagsvik (2000), Menzel (2015) and Goyal et al (2023).

The model represents the dyadic utility functions as deterministic linear utility functions of
dyadic variables. These utility functions are functions of observed characteristics of the women
and men.
These functions are entered as terms in the function call
to \code{\link{rpm}}. This function simulates from such a model.
}
\section{Methods (by class)}{
\itemize{
\item \code{gof(rpm)}: Calculate goodness-of-fit statistics for Revealed Preference Matchings Model based on observed data

}}
\section{Functions}{
\itemize{
\item \code{plot(gofrpm)}: \code{\link{plot.gofrpm}} plots diagnostics such empirical p-value
based on chi-square statistics and KL divergences.
See \code{\link{rpm}} for more information on these models.

}}
\examples{
library(rpm)
\donttest{
data(fauxmatching)
fit <- rpm(~match("edu") + WtoM_diff("edu",3),
          Xdata=fauxmatching$Xdata, Zdata=fauxmatching$Zdata,
          X_w="X_w", Z_w="Z_w",
          pair_w="pair_w", pair_id="pair_id", Xid="pid", Zid="pid",
          sampled="sampled")
a <- gof(fit)
}
}
\references{
Goyal, Shuchi; Handcock, Mark S.; Jackson, Heide M.; Rendall, Michael S. and Yeung, Fiona C. (2023).
\emph{A Practical Revealed Preference Model for Separating Preferences and Availability Effects in Marriage Formation},
\emph{Journal of the Royal Statistical Society}, A. \doi{10.1093/jrsssa/qnad031} 

Dagsvik, John K. (2000) \emph{Aggregation in Matching Markets} \emph{International Economic Review}, Vol. 41, 27-57.
JSTOR: https://www.jstor.org/stable/2648822, \doi{10.1111/1468-2354.00054}

Menzel, Konrad (2015).
\emph{Large Matching Markets as Two-Sided Demand Systems}
Econometrica, Vol. 83, No. 3 (May, 2015), 897-941. \doi{10.3982/ECTA12299}
}
\keyword{graphs}
\keyword{models}
